# lab04.py
# Walker M. White (wmw2), Lillian Lee (ljl2)
# September 6, 2013
"""Functions for handling Point objects

This module provides several functions for working with the Point
class (which is provided by the module tuple3d).  

The functions included here may include intentional errors."""


def has_a_zero(p):
    """Returns: True if at least one of the coordinates of Point p is 0
    
    Precondition: p is a Point object"""
    return p.x == 0 and p.y == 0 and p.z == 0


def cycle_left(p):
    """Shift the coordinates of Point p, so each coordinate moves 'left'
    
    The y-coordinate becomes the new x-coordinate,
    the z-coordinate becomes the new y-coordinate,
    and the x-coordinate becomes the new z-coordinate.
    For example, (1,2,3) becomes (2,3,1).
    
    Precondition: p is a Point object"""
    p.x = p.y
    p.y = p.z
    p.z = p.x
