# __main__.py
# Walker M. White (wmw2), Lillian Lee (LJL2), Steve Marschner (SRM2)
# Spring 2013
"""__main__ module for Breakout-like lecture demos

This is the module with the application code.  Make sure that this module is
in a folder with the following files:

    controller.py (the primary controller class)
    graphics.py   (the graphics widgets for the view)
    graphics.kv   (the layout code for the view)

In addition, you should have the following subfolders

    Fonts         (fonts to use for GLabel)
    Sounds        (sound effects for the game)
    Images        (image files to use in the game)

Moving any of these folders or files will prevent the game from working properly"""
from kivy.app import App
from kivy.config import Config
import controller
import sys


class LectureApp(App):
    """Application class for lecture demos.

    Extends the Kivy App class.  It integrates the .kv file with .py methods.
    It is invoked at start-up and then never used again."""
    _controller = None # The controller class (held as field to prevent garbage collection)

    def build(self):
        """Creates the new Window and instantiates the game controller."""""
        Config.set('graphics', 'width', str(controller.WINDOW_WIDTH))
        Config.set('graphics', 'height', str(controller.WINDOW_HEIGHT))
        self._controller = controller.Controller()
        return self._controller.view


# Application code
if __name__ == '__main__':
    LectureApp().run()
