# cunittest2.py
#  Lillian Lee (LJL2), Steve Marschner (srm2), Walker M. White (wmw2)
# Feb 24, 2013
"""Unit-test support functions.

This module provides more "user friendly" assert functions;
they are intended to integrate with stack-trace info when errors occur."""
import numpy


def assert_equals(expected,received):
    """Raise an AssertionError if expected and received differ, with minimal
    debug info.

    Definition of "differ" is != .

    Example message for assertion error:
    cunittest2: Expected 'yes' but instead got 'no'
    """
    if (expected != received):
        msg = ("cunittest2: Expected " + repr(expected) +
                " but instead got " + repr(received))
        raise AssertionError(msg)


def assert_true(received):
    """Raise an AssertionError if received is False.

    Error message for assertion error:
    cunittest2: Expected True but instead got False
    """
    if (not received):
        msg = "cunittest2: Expected True but instead got False"
        raise AssertionError(msg)


def assert_floats_equal(expected, received):
    """Raise an AssertionError if floats expected and received differ, with
    minimal debug info.

    The definition of "differ" here is as numpy defines it.

    Example message for assertion error:
    cunittest2: Expected '1.3' but instead got '1.5'

    Precondition: expected and received are each numbers (either floats or ints).
    If the first argument is not a number, a TypeError with message like
    'cunittest2 assert_floats_equal: first argument 'alas' is not a number'
    is raised. If the first argument is a number but the second isn't, a
    TypeError with message like
    'cunittest2 assert_floats_equal: second argument 'alack' is not a number'
    is raised.

    """
    number = [float, int]  # list of number types
    if type(expected) not in number:
        msg = ("cunittest2 assert_floats_equal: " +
                "first argument " + repr(expected) +" is not a number")
        raise TypeError(msg)

    if type(received) not in number:
        msg = ("cunittest2 assert_floats_equal: " +
              "second argument " + repr(received) +" is not a number")
        raise TypeError(msg)

    if (not numpy.allclose([expected],[received])):
        msg = ("cunittest2: Expected " + repr(expected) +
            " but instead got " + repr(received))
        raise AssertionError(msg)
