# hand.py
# Steve Marschner (srm2) and Lillian Lee (ljl2)
# March 13, 2013
"""Lecture demo: class to represent poker hands.
"""

import card
import random

class Hand(object):
    """Instances represent a hand in poker.
    
    Instance variables:
        cards [list of Card]: cards in the hand
        
    This list is sorted according to the ordering defined by the Card class.
    """
    
    HAND_TYPE_NAMES = ["1 pair", "3 of a kind", "2 pair", "straight", "flush",
                       "full house", "4 of a kind", "straight flush"]
    NUM_HAND_TYPES = len(HAND_TYPE_NAMES)

    def __init__(self, deck, n):
        """Draw a hand of n cards.
        Pre: deck is a list of >= n cards.  Deck is shuffled.
        """
        self.cards = []
        for k in range(n):
            self.cards.append(deck.pop(0))
        self.cards.sort()
        
    def is_pair(self):
        """Return: This hand contains a pair."""
        return False

    def is_2pair(self):
        """Return: This hand contains two distinct pairs."""
        return False
    
    def is_3kind(self):
        """Return: This hand contains three of a kind."""
        return False
        
    def is_straight(self):
        """Return: This hand contains five cards that are all in sequence."""
        return False
                
    def is_flush(self):
        """Return: This hand contains five cards of the same suit."""
        return False
        
    def is_full_house(self):
        """Return: This hand contains three of a kind and a distinct pair."""
        return False
        
    def is_4kind(self):
        """Return: This hand contains four of a kind."""
        return False
        
    def is_straight_flush(self):
        """Return: This hand contains 5 cards of the same suit that are all
        in sequence."""
        return False
        
    def discard(self, k):
        """Discard the k-th card, counting from zero.
        Precondition: Hand contains at least k+1 cards
        """
        self.cards.remove(k)
        
    def __str__(self):
        return ', '.join(map(str, self.cards))



























#Extra stuff...

#    def get_types(self):
#        """Return: a list of booleans indicating whether this hand is or is not
#        each of the hand types, indexed like HAND_TYPE_NAMES."""
#        return [self.is_pair(), self.is_3kind(), self.is_2pair(),
#                self.is_straight(), self.is_flush(), self.is_full_house(),
#                self.is_4kind(), self.is_straight_flush()]
"""                
            *or*
             text is a string of the form '3D 5H KS', consisting of two-
             character codes acceptable to card.Card separated by spaces.

"""