# nets.py
## Lillian Lee (LJL2), Steve Marschner (srm2)
# Mar 5, 2013

import last


def newid(fname, mname, lname, all_last):
    """Returns: NetID for new Cornellian named fname mname lname, and
    updates all_last appropriately.

    The new NetID is a string of this person's initials (first initial first)
    and the next available numerical suffix, according to the all_last.

    Preconds: first three arguments are lowercase strings; only mname can be empty.
    all_last a list of LastUsed objects, all with distinct prefixes.  It can
    be empty. """

    inits = fname[0] + mname[0:1] + lname[0]  # slicing trick
    ## alternate solution:
    # inits = fname[0] + (mname[0] if len(mname==0) else '') + lname[0]
    ## or, use if-else based length of mname

    i = last.ind(all_last, inits)  # inits is new iff i is -1

    if i != -1:
        all_last[i].suffix = all_last[i].suffix + 1
        suf = all_last[i].suffix
    else:
        all_last.append(last.LastUsed(inits,1))
        suf = 1

    return inits + str(suf)
