# last.py
# Lillian Lee (LJL2), Steve Marschner (srm2)
# Mar 5, 2013

"""Module for tracking used netids (used in CS1110 Sp 2013 prelim 1)"""


class LastUsed(object):
    """Instance stores the last used numerical suffix for netids with a
    given initials, assuming suffixes are assigned in ascending order
    starting with 1.

    Instance variables:
        prefix [str]: string of 1 or more lowercase characters,
                      representing a person's initials (up to three allowed)
        suffix [int]: > 0."""

    def __init__(self, p, s):
        """Initializer: a new LastUsed with prefix p, suffix s.

        Preconds: p a non-empty string of all lowercase letters,
        suffix an int > 0."""
        self.prefix = p
        self.suffix = s

    def __str__(self):
        """Returns: string that is the netid that this LastUsed object
        represents (in lowercase)"""
        return self.prefix + str(self.suffix)


def ind(lulist, p):
    """Returns: index in lulist of LastUsed object with prefix p
    (-1 if no such object)

    Preconds: lulist a (possibly empty) list of LastUsed objects, each with
    distinct prefixes. p a non-empty string of lowercase letters
    """
    # loop invariante: no matching object in lulist[0..i-1]
    i = 0
    while i < len(lulist) and lulist[i].prefix != p:
        i = i+1

    return i if i < len(lulist) else -1
