# codetest.py
# Lillian Lee (LJL2), Steve Marschner (srm2)
# Mar 6, 2013

"""Test prelim modules"""

import last
import cunittest2
import nets


def testind():
    """Test the ind fn in last"""
    lt = []
    cunittest2.assert_equals(-1, last.ind(lt, 'srm'))
    lt = [last.LastUsed('srm',2)]
    cunittest2.assert_equals(0, last.ind(lt, 'srm'))
    lt = [last.LastUsed('ljl', 3), last.LastUsed('srm',2)]
    cunittest2.assert_equals(1, last.ind(lt, 'srm'))
    lt = [last.LastUsed('ljl', 4), last.LastUsed('wmw', 2)]
    cunittest2.assert_equals(-1, last.ind(lt, 'srm'))

    print "All tests for ind passed"


def testnew():
    """Test the newid fn in nets"""
    # test empty list
    mylist = []
    cunittest2.assert_equals('srm1', nets.newid('sa', 'ra', 'max', mylist))
    cunittest2.assert_equals('srm2', nets.newid('sa', 'ra', 'max', mylist))
    #test a new name
    cunittest2.assert_equals('ll1', nets.newid('la', '', 'lee', mylist))
    # test an old name, and also a LastUsed not in first position
    cunittest2.assert_equals('ll2', nets.newid('laci', '', 'lee', mylist))
    #test having a middle initial
    cunittest2.assert_equals('ljl1', nets.newid('li', 'joon', 'lee', mylist))
    print "All tests for newid passed"

if __name__ == '__main__':
    testind()
    testnew()
    print "All tests for prelim1 module code passed"

