# test_lab07.py
# Lillian Lee (LJL2) and Walker White (wmw2)
# October 15, 2013
"""Test cases for lab7.py"""

from cornelltest import *
from lab07 import *

def test_numberof():
    mylist = [5, 3, 3455, 74, 74, 74, 3]
    assert_equals(3, numberof(mylist,74))
    assert_equals(2, numberof(mylist,3))
    assert_equals(0, numberof(mylist,4))
    assert_equals(1, numberof([4],4))
    assert_equals(0, numberof([],4))

def test_number_not():
    mylist = [5, 3, 3455, 74, 74, 74, 3]
    assert_equals(4, number_not(mylist,74))
    assert_equals(5, number_not(mylist,3))
    assert_equals(7, number_not(mylist,4))
    assert_equals(1, number_not([3],4))
    assert_equals(0, number_not([],4))
    
def test_replace():
    assert_equals([4], replace([5],5,4))
    assert_equals([], replace([], 1, 2))
    mylist = [5, 3, 3455, 74, 74, 74, 3]
    assert_equals([5, 20, 3455, 74, 74, 74, 20], replace(mylist,3, 20))
    assert_equals([5, 3, 3455, 74, 74, 74, 3], replace(mylist, 1, 3))
    
def test_remove_dups():
    assert_equals([], remove_dups([]))
    assert_equals([3], remove_dups([3,3]))
    assert_equals([4], remove_dups([4]))
    assert_equals([5], remove_dups([5, 5]))
    assert_equals([1,2,3,4,5,1], remove_dups([1,2,2,3,3,3,4,5,1,1,1]))
    
    # test for whether the code is really returning a copy of the original list
    mylist = [3]
    assert_equals(False, mylist is remove_dups(mylist))
 
def test_remove_first():
    assert_equals([],remove_first([],3))
    assert_equals([],remove_first([3],3))
    assert_equals([3],remove_first([3],4))
    assert_equals([3, 4, 4, 5],remove_first([3, 4, 4, 4, 5],4))
    assert_equals([3, 5, 4, 4, 4],remove_first([3, 4, 5, 4, 4, 4],4))
 
    
def test_reverse1():
    assert_equals([], reverse1([]))
    assert_equals([3], reverse1([3]))
    assert_equals([1,2,3], reverse1([3,2,1]))
    mylist = [3]
    assert_equals(False, mylist is reverse1(mylist))
 
def test_reverse2():
    assert_equals([], reverse2([]))
    assert_equals([3], reverse2([3]))
    assert_equals([1,2,3], reverse2([3,2,1]))
    mylist = [3]
    assert_equals(False, mylist is reverse2(mylist))
 
def test_sum_list():
    assert_equals(0, sum_list([]))
    assert_equals(34, sum_list([34]))
    assert_equals(46, sum_list([7,34,1,2,2]))
    
def test_sum_to():
    assert_equals(1, sum_to(1))
    assert_equals(6, sum_to(3))
    assert_equals(15, sum_to(5))
    
def test_num_digits():
    assert_equals(1, num_digits(0))
    assert_equals(1, num_digits(3))
    assert_equals(2, num_digits(34))
    assert_equals(4, num_digits(1356))
    
def test_sum_digits():
    assert_equals(0, sum_digits(0))
    assert_equals(3, sum_digits(3))
    assert_equals(7, sum_digits(34))
    assert_equals(12, sum_digits(345))
    
def test_number2():
    assert_equals(0, number2(0))
    assert_equals(1, number2(2))
    assert_equals(3, number2(234252))
    
def test_into():
    assert_equals(0, into(5,3))
    assert_equals(1, into(6, 3))
    assert_equals(4, into(3*3*3*3*7,3))
    
def test_exp():
    assert_equals(1, exp(3, 0))
    assert_equals(9, exp(3, 2))
    assert_equals(32, exp(2,5))
    
    
# Script Code
if __name__ == '__main__':
    test_numberof()
    test_number_not()
    test_replace()
    test_remove_dups()
    test_remove_first()
    test_reverse1()
    test_reverse2()
    test_sum_list()
    test_sum_to()
    test_num_digits()
    test_sum_digits()
    test_number2()
    test_into()
    test_exp()
    print "Module recursive.py is working correctly"