/* TemperatureView.java
 *
 * Walker M. White
 * September 22, 2002
 */
package converter;

import java.awt.*;
import javax.swing.*;

/**
 * This is the VIEW for the TemperatureConverter application.  The
 * view must do all of the following:
 * <ul>
 * <li>Instantiate all of the graphical components.</li>
 * <li>Position all of the graphical components.</li>
 * </ul>
 * 
 * This version of the view is different from previous temperature
 * converter examples.  Instead of making it an extension of a 
 * JFrame, we make it an extension of a JPanel.  That way it can
 * be embedded in either a JFrame (for an application) or a JApplet.
 * 
 * @author  Walker M. White
 * @version 9/22/2002
 */
public class TemperatureView extends JPanel {

    /** The graphical components. */
    private javax.swing.JLabel farenheitLabel;
    private javax.swing.JTextField farenheitField;
    private javax.swing.JLabel centigradeLabel;
    private javax.swing.JTextField centigradeField;
    
    
    /** Constructor: a new TemperatureConverter GUI */
    public TemperatureView() {
        initializeView();
    }

    /**
     * Initialize all the GUI components and lay them out in the Frame.
     */    
    public void initializeView() {
        /** Initialize the components */
        farenheitLabel  = new javax.swing.JLabel();
        farenheitField  = new javax.swing.JTextField();
        centigradeLabel = new javax.swing.JLabel();
        centigradeField = new javax.swing.JTextField();
        
        /** Lay everything out nicely with GridBagLayout */
        setLayout(new java.awt.GridBagLayout());
        java.awt.GridBagConstraints gridBagConstraints1;     
        
        farenheitLabel.setText("Farenheit");
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.insets = new java.awt.Insets(0, 15, 0, 5);
        add(farenheitLabel, gridBagConstraints1);
        
        farenheitField.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
        farenheitField.setMinimumSize(new java.awt.Dimension(60, 21));
        farenheitField.setPreferredSize(new java.awt.Dimension(60, 21));
        
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        add(farenheitField, gridBagConstraints1);
        
        centigradeLabel.setText("Centigrade");
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.insets = new java.awt.Insets(10, 10, 10, 5);
        add(centigradeLabel, gridBagConstraints1);
        
        centigradeField.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
        centigradeField.setMinimumSize(new java.awt.Dimension(60, 21));
        centigradeField.setPreferredSize(new java.awt.Dimension(60, 21));
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.insets = new java.awt.Insets(0, 0, 0, 15);
        add(centigradeField, gridBagConstraints1);
    }
    
    /** 
     * Yields: the GUI component for storing farenheit
     */
    public JTextField getFarenheitField() {
        return farenheitField;
    }

    /** 
     * Yields: the GUI component for storing farenheit
     */
    public JTextField getCentigradeField() {
        return centigradeField;
    }

}