/*
 * TemperatureListener.java
 *
 * Walker M. White
 *
 * September 22, 2002
 */
package converter;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/**
 * This class represents the CONTROLLER.  The controller is responsible for 
 * sending messages between the view and the model. Therefore, it needs to 
 * have fields referencing the model and the view so that it can send each 
 * of them messages. In most cases (including this one), the controller is
 * also responsible for starting the program and so will have a method
 * named main(String[]).
 * 
 * This version of the controller can server either as an application
 * (because it has a main method) or as an applet (it extends JApplet)
 * 
 * @author  Walker M. White
 * @version 9/22/2002
 */
public class TemperatureConverter extends JApplet implements ActionListener {
  
    /** The view to display the temperature. */
    private TemperatureView view;
    
    /** The model to hold the temperature value */
    TemperatureModel model;

    /** 
     * Constructor: a new instance of a temperature converter
     * application.  This constructor instantiates the model
     * and view and "glues" everything together.
     */
    public TemperatureConverter() {
        model = new TemperatureModel();
        view  = new TemperatureView();
        
        // Register with the view to receive user input.
        view.getFarenheitField().addActionListener(this);
        view.getCentigradeField().addActionListener(this);
        
        // Initialize the values for the text fields.
        view.getFarenheitField().setText(model.getFarenheitAsString());
        view.getCentigradeField().setText(model.getCentigradeAsString());
    }
    
    /** Place the view inside of a JFrame and make it visible */
    private void initAsApplication() {
    	JFrame frame = new JFrame("Temperature Converter");
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE );
    	frame.getContentPane().add(view);
    	frame.pack();
    	frame.setVisible(true);
    }

	/** Initialize this application as an applet */    
    public void init() {
    	getContentPane().add(view);
    }
    
    /** Called when the application starts */
    public void start() {
    	// Do nothing
    }
    
    /** Called when the application stops */
    public void stop() { 
    	// Do nothing
    }
    
	/** Destroy resources */    
    public void destroy() {
    	// Nothing to destroy (no images loaded...)
    }

    
    /** 
     * Method called when user types return in text field; 
     * identify the text field and react appropriately.
     */
    public void actionPerformed(java.awt.event.ActionEvent event) {

        /* Compute the source */
        JTextField field = (JTextField)event.getSource();

        try {
            /* Update the model with the appropriate new data. */
            if (field.equals(view.getFarenheitField())) {
                model.setFarenheit(Double.parseDouble(field.getText()));
            } else {
                model.setCentigrade(Double.parseDouble(field.getText()));
            }
            /* If there was an exception, nothing was updated. */
        } catch (NumberFormatException e) {}
        
        /* Update the view with the new (or old) values. */
        view.getFarenheitField().setText(model.getFarenheitAsString());
        view.getCentigradeField().setText(model.getCentigradeAsString());
    }
 
     /**
     * The main method, this is used to launch the application.
     */
    public static void main(String args[]) {
        new TemperatureConverter().initAsApplication();
    }
}
