/** An object is a date. To simplify the demo,
 *  we do not check for errors (like the month being 13) */
public class CDate implements Comparable {
    
    private int y; // year of this date
    private int m; // month of this date: in 1..12
    private int d; // day of the month: 1..31
    
    /** Constructor: a Datee with year y, month m, and day d */
    public CDate(int y, int m, int d) {
        this.y= y;
        this.m= m;
        this.d= d;
    }
    
    /** Yields: the year of this date */
    int getYear() { return y; }
    
    /** Yields: the month of the year */
    int getMonth() { return m; }
    
    /** Yields: the day of the month */
    int getDay() { return d; }
    
    /** Yields: a representation of this date, in the form year.month.day */
    public String toString() {
        return y + "." + m + "." + d;
    }
    
    /** compareTo as specified in the Comparable interface */
    public int compareTo(Object ob) {
        if (!(ob instanceof CDate)) {
            throw new ClassCastException("object can't be cast to CDate");
        }
        
        CDate b= (CDate) ob;
        if (y == b.y && m == b.m && d == b.d) {
            return 0;
        }

        if (y < b.y ||
            (y == b.y && m < b.m) ||
            (y == b.y && m == b.m && d < b.d)) {
            return -1;
        }
        
        return 1;
    }
     
}