/*
 * TemperatureConverter.java
 *
 * Walker M. White
 *
 * September 22, 2002
 */
package converter;

import java.awt.*;
import javax.swing.*;

/**
 * This is the VIEW for the TemperatureConverter application.  The
 * view must do all of the following:
 * <ul>
 * <li>Instantiate the window and all of the graphical components.</li>
 * <li>Position all of the graphical components.</li>
 * <li>Instantiate and initialize the model.</li>
 * <li>Link the model and the components together via listeners.</li>
 * </ul>
 * 
 * Note that the view is responsible for instantiating everything else.
 * This means that the view is going to be the main class, the one that
 * we start up from the command line.
 * 
 * @author  Walker M. White
 * @version 9/22/2002
 */
public class TemperatureView extends javax.swing.JFrame {

    /** The graphical components. */
    private javax.swing.JLabel farenheitLabel;
    private javax.swing.JTextField farenheitField;
    private javax.swing.JLabel centigradeLabel;
    private javax.swing.JTextField centigradeField;
    
    
    /** Constructor: a new TemperatureConverter GUI */
    public TemperatureView() {
        initializeView();
        pack();
    }

    /**
     * Initialize all the GUI components and lay them out in the Frame.
     */    
    public void initializeView() {
        /** Initialize the components */
        farenheitLabel  = new javax.swing.JLabel();
        farenheitField  = new javax.swing.JTextField();
        centigradeLabel = new javax.swing.JLabel();
        centigradeField = new javax.swing.JTextField();
        
        /** Lay everything out nicely with GridBagLayout */
        getContentPane().setLayout(new java.awt.GridBagLayout());
        java.awt.GridBagConstraints gridBagConstraints1;
        
        setTitle("Temperature Converter");
        setDefaultCloseOperation(EXIT_ON_CLOSE );
        
        farenheitLabel.setText("Farenheit");
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.insets = new java.awt.Insets(0, 15, 0, 5);
        getContentPane().add(farenheitLabel, gridBagConstraints1);
        
        farenheitField.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
        farenheitField.setMinimumSize(new java.awt.Dimension(60, 21));
        farenheitField.setPreferredSize(new java.awt.Dimension(60, 21));
        
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        getContentPane().add(farenheitField, gridBagConstraints1);
        
        centigradeLabel.setText("Centigrade");
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.insets = new java.awt.Insets(10, 10, 10, 5);
        getContentPane().add(centigradeLabel, gridBagConstraints1);
        
        centigradeField.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
        centigradeField.setMinimumSize(new java.awt.Dimension(60, 21));
        centigradeField.setPreferredSize(new java.awt.Dimension(60, 21));
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.insets = new java.awt.Insets(0, 0, 0, 15);
        getContentPane().add(centigradeField, gridBagConstraints1);
    }
    
    /** 
     * Yields: the GUI component for storing farenheit
     */
    public JTextField getFarenheitField() {
        return farenheitField;
    }

    /** 
     * Yields: the GUI component for storing farenheit
     */
    public JTextField getCentigradeField() {
        return centigradeField;
    }

}
