/*
 * TemperatureListener.java
 *
 * Walker M. White
 *
 * September 22, 2002
 */
package converter;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/**
 * This class is one of the listeners making up the CONTROLLER.  The
 * controller is responsible for sending messages between the view and 
 * the model. Therefore, it needs to have fields referencing the vital 
 * parts of the model and (sometimes) the view so that it can send each 
 * of them messages.
 * 
 * We should note that this is a far more complicated listener than 
 * ones we have seen before.  That is because it listens to more than
 * one component.  It uses the getSource() method from the event to 
 * figure out which component the event has come from.
 * 
 * @author  Walker M. White
 * @version 9/22/2002
 */
public class TemperatureConverter implements ActionListener {
  
    /** The view to display the temperature. */
    private TemperatureView view;
    
    /** The model to hold the temperature value */
    TemperatureModel model;

    /** 
     * Constructor: a new instance of a temperature converter
     * application.  This constructor instantiates the model
     * and view and "glues" everything together.
     */
    public TemperatureConverter() {
        model = new TemperatureModel();
        view  = new TemperatureView();
        
        // Register with the view to receive user input.
        view.getFarenheitField().addActionListener(this);
        view.getCentigradeField().addActionListener(this);
        
        // Initialize the values for the text fields.
        //view.getFarenheitField().setText(model.getFarenheitAsString());
        //view.getCentigradeField().setText(model.getCentigradeAsString());
      
        // Show the view once initialized.
        view.setVisible(true);
    }
    
    /** 
     * Method called when user types return in text field; 
     * identify the text field and react appropriately.
     */
    public void actionPerformed(java.awt.event.ActionEvent event) {

        /* Compute the source */
        JTextField field = (JTextField)event.getSource();

        try {
            /* Update the model with the appropriate new data. */
            if (field.equals(view.getFarenheitField())) {
                model.setFarenheit(Double.parseDouble(field.getText()));
            } else {
                model.setCentigrade(Double.parseDouble(field.getText()));
            }
            /* If there was an exception, nothing was updated. */
        } catch (NumberFormatException e) {}
        
        /* Update the view with the new (or old) values. */
        view.getFarenheitField().setText(model.getFarenheitAsString());
        view.getCentigradeField().setText(model.getCentigradeAsString());
    }
 
     /**
     * The main method, this is used to launch the application.
     */
    public static void main(String args[]) {
        new TemperatureConverter();
    }
}
