/*
 * Decompiled with CFR 0.152.
 */
package acm.util;

import acm.util.ErrorException;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class OptionTable
extends HashMap {
    public OptionTable(String string) {
        this(string, null);
    }

    public OptionTable(String string, String[] stringArray) {
        try {
            StreamTokenizer streamTokenizer = this.createTokenizer(string);
            int n = streamTokenizer.nextToken();
            while (n != -1) {
                if (n != -3) {
                    throw new ErrorException("Illegal option string: " + string);
                }
                String string2 = streamTokenizer.sval;
                if (stringArray != null && !this.keyExists(string2, stringArray)) {
                    throw new ErrorException("Unrecognized option: " + string2);
                }
                n = streamTokenizer.nextToken();
                if (n == 61) {
                    n = streamTokenizer.nextToken();
                    if (n != -3 && n != 34 && n != 39) {
                        throw new ErrorException("Illegal option string: " + string);
                    }
                    this.put(string2, streamTokenizer.sval);
                    n = streamTokenizer.nextToken();
                    continue;
                }
                this.put(string2, "");
            }
        }
        catch (IOException iOException) {
            throw new ErrorException("Illegal option string: " + string);
        }
    }

    public OptionTable(Map map) {
        Iterator iterator = (Iterator)((Object)map.keySet());
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)map.get(string);
            this.put(string, string2);
        }
    }

    public boolean isSpecified(String string) {
        return this.containsKey(string);
    }

    public String getOption(String string) {
        return this.getOption(string, null);
    }

    public String getOption(String string, String string2) {
        String string3 = (String)this.get(string);
        return string3 == null || string3.equals("") ? string2 : string3;
    }

    public int getIntOption(String string) {
        return this.getIntOption(string, 0);
    }

    public int getIntOption(String string, int n) {
        String string2 = this.getOption(string, null);
        if (string2 == null || string2.equals("")) {
            return n;
        }
        return Integer.decode(string2);
    }

    public double getDoubleOption(String string) {
        return this.getDoubleOption(string, 0.0);
    }

    public double getDoubleOption(String string, double d) {
        String string2 = this.getOption(string, null);
        if (string2 == null || string2.equals("")) {
            return d;
        }
        return Double.valueOf(string2);
    }

    private StreamTokenizer createTokenizer(String string) {
        StreamTokenizer streamTokenizer = new StreamTokenizer(new StringReader(string));
        streamTokenizer.resetSyntax();
        streamTokenizer.wordChars(33, 60);
        streamTokenizer.wordChars(62, 126);
        streamTokenizer.quoteChar(34);
        streamTokenizer.quoteChar(39);
        streamTokenizer.whitespaceChars(32, 32);
        streamTokenizer.whitespaceChars(9, 9);
        return streamTokenizer;
    }

    private boolean keyExists(String string, String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            if (string.equals(stringArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

