/*
 * Decompiled with CFR 0.152.
 */
package acm.graphics;

import acm.graphics.GDimension;
import acm.graphics.GFillable;
import acm.graphics.GMath;
import acm.graphics.GObject;
import acm.graphics.GRectangle;
import acm.graphics.GResizable;
import acm.graphics.GScalable;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;

public class GRect
extends GObject
implements GFillable,
GResizable,
GScalable {
    private double frameWidth;
    private double frameHeight;
    private boolean isFilled;
    private Color fillColor;

    public GRect(double d, double d2) {
        this(0.0, 0.0, d, d2);
    }

    public GRect(double d, double d2, double d3, double d4) {
        this.frameWidth = d3;
        this.frameHeight = d4;
        this.setLocation(d, d2);
    }

    public void paint(Graphics graphics) {
        Rectangle rectangle = this.getAWTBounds();
        if (this.isFilled()) {
            graphics.setColor(this.getFillColor());
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.setColor(this.getColor());
        }
        graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void setFilled(boolean bl) {
        this.isFilled = bl;
        this.repaint();
    }

    public boolean isFilled() {
        return this.isFilled;
    }

    public void setFillColor(Color color) {
        this.fillColor = color;
        this.repaint();
    }

    public Color getFillColor() {
        return this.fillColor == null ? this.getColor() : this.fillColor;
    }

    public void setSize(double d, double d2) {
        this.frameWidth = d;
        this.frameHeight = d2;
        this.repaint();
    }

    public final void setSize(GDimension gDimension) {
        this.setSize(gDimension.getWidth(), gDimension.getHeight());
    }

    public GDimension getSize() {
        return new GDimension(this.frameWidth, this.frameHeight);
    }

    public void setBounds(double d, double d2, double d3, double d4) {
        this.frameWidth = d3;
        this.frameHeight = d4;
        this.setLocation(d, d2);
    }

    public final void setBounds(GRectangle gRectangle) {
        this.setBounds(gRectangle.getX(), gRectangle.getY(), gRectangle.getWidth(), gRectangle.getHeight());
    }

    public GRectangle getBounds() {
        return new GRectangle(this.getX(), this.getY(), this.frameWidth + 1.0, this.frameHeight + 1.0);
    }

    public double getWidth() {
        return this.frameWidth;
    }

    public double getHeight() {
        return this.frameHeight;
    }

    public void scale(double d, double d2) {
        this.frameWidth *= d;
        this.frameHeight *= d2;
        this.repaint();
    }

    public final void scale(double d) {
        this.scale(d, d);
    }

    protected Rectangle getAWTBounds() {
        return new Rectangle(GMath.round(this.getX()), GMath.round(this.getY()), GMath.round(this.frameWidth), GMath.round(this.frameHeight));
    }
}

