/*
 * Decompiled with CFR 0.152.
 */
import acm.graphics.GLabel;
import acm.graphics.GObject;
import acm.graphics.GOval;
import acm.graphics.GPoint;
import acm.graphics.GRect;
import acm.program.GraphicsProgram;
import acm.util.MediaTools;
import acm.util.RandomGenerator;
import java.applet.AudioClip;
import java.awt.Color;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

public class Breakout
extends GraphicsProgram {
    private static final int GAME_WIDTH = 480;
    private static final int GAME_HEIGHT = 620;
    private static final int PADDLE_WIDTH = 58;
    private static final int PADDLE_HEIGHT = 11;
    private static final int PADDLE_OFFSET = 30;
    public static final int BRICK_SEP_H = 5;
    private static final int BRICK_SEP_V = 4;
    private static final int BRICK_HEIGHT = 8;
    private static final int BRICK_Y_OFFSET = 70;
    public static int BRICKS_IN_ROW = 10;
    public static int BRICK_ROWS = 10;
    public static int BRICK_WIDTH = 480 / BRICKS_IN_ROW - 5;
    private static final int BALL_DIAMETER = 18;
    private static final int NTURNS = 3;
    private static final Color[] rowColors = new Color[]{Color.red, Color.red, Color.orange, Color.orange, Color.yellow, Color.yellow, Color.green, Color.green, Color.cyan, Color.cyan};
    private GRect paddle = null;
    private GOval ball = null;
    private double vx;
    private double vy;
    private RandomGenerator rgen = new RandomGenerator();
    private int numBricks = 0;
    private int ballsTried = 0;
    private static AudioClip bounceClip = MediaTools.loadAudioClip("bounce.au");

    public static void main(String[] stringArray) {
        Breakout.fixBricks(stringArray);
        String[] stringArray2 = new String[]{"width=480", "height=620"};
        new Breakout().start(stringArray2);
    }

    public static void fixBricks(String[] stringArray) {
        if (stringArray == null || stringArray.length != 2) {
            return;
        }
        try {
            int n = Integer.valueOf(stringArray[0]);
            int n2 = Integer.valueOf(stringArray[1]);
            if (n <= 0 || n2 <= 0) {
                return;
            }
            BRICKS_IN_ROW = n;
            BRICK_ROWS = n2;
            BRICK_WIDTH = 480 / BRICKS_IN_ROW - 5;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        while (true) {
            this.initialize();
            GLabel gLabel = new GLabel("Click mouse to play");
            this.add(gLabel, 10.0, this.paddle.getY() - 20.0);
            this.waitForClick();
            this.pause(500.0);
            this.remove(gLabel);
            this.play();
        }
    }

    private void initialize() {
        this.addKeyListeners();
        this.setFocusable(true);
        this.placeBricks();
        this.placePaddle();
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        System.out.println("Key pressed: " + keyEvent);
    }

    private void play() {
        this.ballsTried = 0;
        while (this.ballsTried < 3 && this.numBricks > 0) {
            this.placeBall();
            boolean bl = true;
            while (this.numBricks > 0 && bl) {
                bl = this.moveBall();
                if (!bl && this.ballsTried < 3) {
                    GLabel gLabel = new GLabel("You lost a ball. Get ready for the next one in 3 seconds.");
                    this.add(gLabel, 10.0, this.paddle.getY() - 20.0);
                    this.pause(3000.0);
                    this.remove(gLabel);
                }
                this.pause(10.0);
            }
        }
        GLabel gLabel = this.ballsTried == 3 ? new GLabel("You lose. Three balls are gone. Click the mouse to play again.") : new GLabel("You win! Congratulations! Click the mouse to play again.");
        this.add(gLabel, 10.0, this.paddle.getY() - 20.0);
        this.waitForClick();
        this.pause(500.0);
        this.removeAll();
    }

    private boolean moveBall() {
        this.ball.move(this.vx, this.vy);
        if (this.vx < 0.0 && this.ball.getX() <= 0.0 || this.vx > 0.0 && this.ball.getX() + 18.0 >= 480.0) {
            this.vx = -this.vx;
        }
        if (this.ball.getY() + 18.0 >= 620.0) {
            this.remove(this.ball);
            ++this.ballsTried;
            return false;
        }
        GObject gObject = this.getCollidingObject();
        if (gObject == this.paddle && this.vy > 0.0) {
            this.fixBallDirection(gObject);
            return true;
        }
        if (gObject instanceof Brick) {
            this.fixBallDirection(gObject);
            ((Brick)gObject).squeak(this);
            this.remove(gObject);
            --this.numBricks;
            return true;
        }
        if (this.vy < 0.0 && this.ball.getY() <= 0.0) {
            this.vy = -this.vy;
        }
        return true;
    }

    private GObject getCollidingObject() {
        double d;
        double d2 = this.ball.getX();
        GObject gObject = this.getElementAt(d2, d = this.ball.getY());
        if (gObject != null) {
            return gObject;
        }
        gObject = this.getElementAt(d2 + 18.0, d);
        if (gObject != null) {
            return gObject;
        }
        gObject = this.getElementAt(d2, d + 18.0);
        if (gObject != null) {
            return gObject;
        }
        gObject = this.getElementAt(d2 + 18.0, d + 18.0);
        if (gObject != null) {
            return gObject;
        }
        return null;
    }

    private void placeBall() {
        this.ball = new GOval(240.0, 310.0, 18.0, 18.0);
        this.ball.setFilled(true);
        this.ball.setFillColor(Color.black);
        this.ball.setColor(Color.black);
        this.add(this.ball);
        this.vx = this.rgen.nextDouble(1.0, 3.0);
        if (!this.rgen.nextBoolean(0.5)) {
            this.vx = -this.vx;
        }
        this.vy = 3.0;
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        GPoint gPoint = new GPoint(mouseEvent.getPoint());
        double d = 29.0;
        double d2 = Math.max(0.0, Math.min(gPoint.getX() - d, 422.0));
        this.paddle.setLocation(d2, this.paddle.getY());
        System.out.println("Paddle at " + d2 + " bounds " + this.paddle.getBounds());
    }

    private void placeBricks() {
        double d = 70.0;
        double d2 = 2.0;
        for (int i = 0; i != BRICK_ROWS; ++i) {
            double d3 = d2;
            for (int j = 0; j != BRICKS_IN_ROW; ++j) {
                Brick brick = new Brick(d3, d, BRICK_WIDTH, 8.0);
                brick.setFilled(true);
                brick.setFillColor(rowColors[i % rowColors.length]);
                brick.setColor(rowColors[i % rowColors.length]);
                this.add(brick);
                ++this.numBricks;
                d3 = d3 + (double)BRICK_WIDTH + 5.0;
            }
            d = d + 8.0 + 4.0;
        }
    }

    private void placePaddle() {
        this.paddle = new GRect(240.0, 579.0, 58.0, 11.0);
        this.paddle.setFilled(true);
        this.paddle.setFillColor(Color.black);
        this.paddle.setColor(Color.black);
        this.add(this.paddle);
        this.addMouseListeners();
    }

    private void fixBallDirection(GObject gObject) {
        this.vy = -this.vy;
        double d = gObject.getWidth();
        double d2 = gObject.getLocation().getX();
        if (this.vx > 0.0 && this.ball.getX() <= d2 + d / 4.0) {
            this.vx = -this.vx;
            return;
        }
        if (this.vx < 0.0 && this.ball.getX() >= d2 + 3.0 * d / 4.0) {
            this.vx = -this.vx;
            return;
        }
    }

    public static String toString(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        String string = "[";
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                string = string + ", ";
            }
            string = string + stringArray[i];
        }
        return string + "]";
    }
}

