/*
 * Decompiled with CFR 0.152.
 */
package acm.util;

import acm.util.EmptyContainer;
import acm.util.ErrorException;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;

public class JTFTools {
    private static boolean fontFamilyTableInitialized = false;
    private static Hashtable fontFamilyTable = null;
    private static Hashtable appletTable = new Hashtable();
    private static Applet mostRecentApplet = null;
    private static final String[] SERIF_SUBSTITUTIONS = new String[]{"Serif", "Times", "TimesRoman", "Times-Roman"};
    private static final String[] SANSSERIF_SUBSTITUTIONS = new String[]{"SansSerif", "Helvetica", "Arial"};
    private static final String[] MONOSPACED_SUBSTITUTIONS = new String[]{"Monospaced", "Courier", "Monaco"};

    public static Container createEmptyContainer() {
        return new EmptyContainer();
    }

    public static Frame getEnclosingFrame(Component component) {
        while (component != null && !(component instanceof Frame)) {
            component = component.getParent();
        }
        return (Frame)component;
    }

    public static Font getStandardFont(Font font) {
        if (!fontFamilyTableInitialized) {
            JTFTools.initFontFamilyTable();
        }
        if (font == null || fontFamilyTable == null) {
            return font;
        }
        String string = font.getFamily();
        if (fontFamilyTable.get(JTFTools.trimFamilyName(string)) != null) {
            return font;
        }
        if (string.equals("Serif") || string.equals("Times")) {
            string = JTFTools.getFirstAvailableFontSubstitution(SERIF_SUBSTITUTIONS);
        } else if (string.equals("SansSerif")) {
            string = JTFTools.getFirstAvailableFontSubstitution(SANSSERIF_SUBSTITUTIONS);
        } else if (string.equals("Monospaced")) {
            string = JTFTools.getFirstAvailableFontSubstitution(MONOSPACED_SUBSTITUTIONS);
        } else {
            return font;
        }
        if (string == null) {
            return font;
        }
        return new Font(string, font.getStyle(), font.getSize());
    }

    public static Font decodeFont(String string) {
        return JTFTools.decodeFont(string, null);
    }

    public static Font decodeFont(String string, Font font) {
        String string2 = string;
        int n = 0;
        int n2 = 12;
        int n3 = string.indexOf(45);
        if (n3 >= 0) {
            string2 = string.substring(0, n3);
            if ((n3 = (string = string.substring(n3 + 1)).indexOf(45)) >= 0) {
                String string3 = string.substring(0, n3).toLowerCase();
                if (string3.equals("*") && font != null) {
                    n = font.getStyle();
                } else if (string3.equals("plain")) {
                    n = 0;
                } else if (string3.equals("bold")) {
                    n = 1;
                } else if (string3.equals("italic")) {
                    n = 2;
                } else if (string3.equals("bolditalic")) {
                    n = 3;
                } else {
                    throw new ErrorException("Illegal font style");
                }
                string = string.substring(n3 + 1);
            }
            if (string.equals("*") && font != null) {
                n2 = font.getSize();
            } else {
                try {
                    n2 = Integer.valueOf(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ErrorException("Illegal font size");
                }
            }
        }
        if (string2.equals("*")) {
            string2 = font == null ? "Default" : font.getName();
        } else {
            if (!fontFamilyTableInitialized) {
                JTFTools.initFontFamilyTable();
            }
            if (fontFamilyTable != null && (string2 = (String)fontFamilyTable.get(JTFTools.trimFamilyName(string2))) == null) {
                string2 = "Default";
            }
        }
        return JTFTools.getStandardFont(new Font(string2, n, n2));
    }

    public static Color decodeColor(String string) {
        if (string.equalsIgnoreCase("desktop")) {
            return SystemColor.desktop;
        }
        if (string.equalsIgnoreCase("activeCaption")) {
            return SystemColor.activeCaption;
        }
        if (string.equalsIgnoreCase("activeCaptionText")) {
            return SystemColor.activeCaptionText;
        }
        if (string.equalsIgnoreCase("activeCaptionBorder")) {
            return SystemColor.activeCaptionBorder;
        }
        if (string.equalsIgnoreCase("inactiveCaption")) {
            return SystemColor.inactiveCaption;
        }
        if (string.equalsIgnoreCase("inactiveCaptionText")) {
            return SystemColor.inactiveCaptionText;
        }
        if (string.equalsIgnoreCase("inactiveCaptionBorder")) {
            return SystemColor.inactiveCaptionBorder;
        }
        if (string.equalsIgnoreCase("window")) {
            return SystemColor.window;
        }
        if (string.equalsIgnoreCase("windowBorder")) {
            return SystemColor.windowBorder;
        }
        if (string.equalsIgnoreCase("windowText")) {
            return SystemColor.windowText;
        }
        if (string.equalsIgnoreCase("menu")) {
            return SystemColor.menu;
        }
        if (string.equalsIgnoreCase("menuText")) {
            return SystemColor.menuText;
        }
        if (string.equalsIgnoreCase("text")) {
            return SystemColor.text;
        }
        if (string.equalsIgnoreCase("textText")) {
            return SystemColor.textText;
        }
        if (string.equalsIgnoreCase("textHighlight")) {
            return SystemColor.textHighlight;
        }
        if (string.equalsIgnoreCase("textHighlightText")) {
            return SystemColor.textHighlightText;
        }
        if (string.equalsIgnoreCase("textInactiveText")) {
            return SystemColor.textInactiveText;
        }
        if (string.equalsIgnoreCase("control")) {
            return SystemColor.control;
        }
        if (string.equalsIgnoreCase("controlText")) {
            return SystemColor.controlText;
        }
        if (string.equalsIgnoreCase("controlHighlight")) {
            return SystemColor.controlHighlight;
        }
        if (string.equalsIgnoreCase("controlLtHighlight")) {
            return SystemColor.controlLtHighlight;
        }
        if (string.equalsIgnoreCase("controlShadow")) {
            return SystemColor.controlShadow;
        }
        if (string.equalsIgnoreCase("controlDkShadow")) {
            return SystemColor.controlDkShadow;
        }
        if (string.equalsIgnoreCase("scrollbar")) {
            return SystemColor.scrollbar;
        }
        if (string.equalsIgnoreCase("info")) {
            return SystemColor.info;
        }
        if (string.equalsIgnoreCase("infoText")) {
            return SystemColor.infoText;
        }
        if (string.equalsIgnoreCase("black")) {
            return Color.black;
        }
        if (string.equalsIgnoreCase("blue")) {
            return Color.blue;
        }
        if (string.equalsIgnoreCase("cyan")) {
            return Color.cyan;
        }
        if (string.equalsIgnoreCase("darkGray")) {
            return Color.darkGray;
        }
        if (string.equalsIgnoreCase("DARK_GRAY")) {
            return Color.darkGray;
        }
        if (string.equalsIgnoreCase("gray")) {
            return Color.gray;
        }
        if (string.equalsIgnoreCase("green")) {
            return Color.green;
        }
        if (string.equalsIgnoreCase("lightGray")) {
            return Color.lightGray;
        }
        if (string.equalsIgnoreCase("LIGHT_GRAY")) {
            return Color.lightGray;
        }
        if (string.equalsIgnoreCase("magenta")) {
            return Color.magenta;
        }
        if (string.equalsIgnoreCase("orange")) {
            return Color.orange;
        }
        if (string.equalsIgnoreCase("pink")) {
            return Color.pink;
        }
        if (string.equalsIgnoreCase("red")) {
            return Color.red;
        }
        if (string.equalsIgnoreCase("white")) {
            return Color.white;
        }
        if (string.equalsIgnoreCase("yellow")) {
            return Color.yellow;
        }
        try {
            return Color.decode(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ErrorException("Illegal color value");
        }
    }

    public static void registerApplet(Applet applet) {
        JTFTools.registerApplet(applet, Thread.currentThread());
        mostRecentApplet = applet;
    }

    public static void registerApplet(Applet applet, Thread thread) {
        appletTable.put(thread, applet);
    }

    public static Applet getApplet() {
        Applet applet = (Applet)appletTable.get(Thread.currentThread());
        if (applet == null) {
            applet = mostRecentApplet;
        }
        return applet;
    }

    public static void pause(double d) {
        Applet applet = (Applet)appletTable.get(Thread.currentThread());
        if (applet == null) {
            applet = mostRecentApplet;
            appletTable.put(Thread.currentThread(), applet);
        }
        try {
            int n = (int)d;
            int n2 = (int)Math.round((d - (double)n) * 1000000.0);
            Thread.sleep(n, n2);
        }
        catch (InterruptedException interruptedException) {}
    }

    public static void terminateAppletThreads(Applet applet) {
        try {
            Thread thread = Thread.currentThread();
            Class<?> clazz = Class.forName("java.lang.Thread");
            Method method = clazz.getMethod("stop", new Class[0]);
            Enumeration enumeration = appletTable.elements();
            while (enumeration.hasMoreElements()) {
                Thread thread2 = (Thread)enumeration.nextElement();
                if (thread2 == thread || !thread2.isAlive() || !JTFTools.isAnonymous(thread2) || applet != (Applet)appletTable.get(thread2)) continue;
                method.invoke((Object)thread2, new Object[0]);
            }
        }
        catch (Exception exception) {}
    }

    public static boolean isAnonymous(Thread thread) {
        String string = thread.getName();
        if (!string.startsWith("Thread-")) {
            return false;
        }
        int n = 7;
        while (n < string.length()) {
            if (!Character.isDigit(string.charAt(n))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private static void initFontFamilyTable() {
        fontFamilyTableInitialized = true;
        try {
            Class<?> clazz = Class.forName("java.awt.Toolkit");
            Method method = clazz.getMethod("getFontList", new Class[0]);
            String[] stringArray = (String[])method.invoke((Object)Toolkit.getDefaultToolkit(), new Object[0]);
            fontFamilyTable = new Hashtable();
            int n = 0;
            while (n < stringArray.length) {
                fontFamilyTable.put(JTFTools.trimFamilyName(stringArray[n]), stringArray[n]);
                ++n;
            }
            fontFamilyTable.put("serif", JTFTools.getFirstAvailableFontSubstitution(SERIF_SUBSTITUTIONS));
            fontFamilyTable.put("sansserif", JTFTools.getFirstAvailableFontSubstitution(SANSSERIF_SUBSTITUTIONS));
            fontFamilyTable.put("monospaced", JTFTools.getFirstAvailableFontSubstitution(MONOSPACED_SUBSTITUTIONS));
        }
        catch (Exception exception) {
            fontFamilyTable = null;
        }
    }

    private static String getFirstAvailableFontSubstitution(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            if (fontFamilyTable.get(JTFTools.trimFamilyName(stringArray[n])) != null) {
                return stringArray[n];
            }
            ++n;
        }
        return null;
    }

    private static String trimFamilyName(String string) {
        String string2 = "";
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c != ' ' && c != '-') {
                string2 = String.valueOf(string2) + Character.toLowerCase(c);
            }
            ++n;
        }
        return string2;
    }
}

