/*
 * Decompiled with CFR 0.152.
 */
package acm.program;

import acm.io.IOConsole;
import acm.program.OldStyleCheckBoxMenuItem;
import acm.program.OldStyleMenuItem;
import acm.program.Program;
import acm.program.ProgramMenuListener;
import acm.util.ErrorException;
import acm.util.Platform;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class ProgramMenuBar
extends JMenuBar {
    private Program activeProgram;
    private ProgramMenuListener listener = new ProgramMenuListener(this);
    private IOConsole activeConsole;

    public ProgramMenuBar() {
        this.init();
    }

    public void init() {
        this.addFileMenu();
        this.addEditMenu();
    }

    public void addFileMenu() {
        if (this.patchModeInEffect("File")) {
            return;
        }
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic('F');
        this.addFileMenuItems(jMenu);
        this.add(jMenu);
    }

    public void addEditMenu() {
        if (this.patchModeInEffect("Edit")) {
            return;
        }
        JMenu jMenu = new JMenu("Edit");
        jMenu.setMnemonic('E');
        this.addEditMenuItems(jMenu);
        this.add(jMenu);
    }

    public void addFileMenuItems(JMenu jMenu) {
        jMenu.add(this.createStandardMenuItem("Save"));
        jMenu.add(this.createStandardMenuItem("Save As"));
        jMenu.addSeparator();
        jMenu.add(this.createStandardMenuItem("Print"));
        jMenu.add(this.createStandardMenuItem("Print Console"));
        jMenu.add(this.createStandardMenuItem("Script"));
        jMenu.addSeparator();
        jMenu.add(this.createStandardMenuItem("Quit"));
    }

    public void addEditMenuItems(JMenu jMenu) {
        jMenu.add(this.createStandardMenuItem("Cut"));
        jMenu.add(this.createStandardMenuItem("Copy"));
        jMenu.add(this.createStandardMenuItem("Paste"));
        jMenu.add(this.createStandardMenuItem("Select All"));
    }

    public JMenuItem createStandardMenuItem(String string) {
        JMenuItem jMenuItem = null;
        if (string.equals("Quit")) {
            jMenuItem = Platform.isMac() ? this.createStandardItem("Quit", 81) : this.createStandardItem("Exit", 0);
        } else if (string.equals("Cut")) {
            jMenuItem = this.createStandardItem(Platform.isMac() ? "Cut" : "Cut (x)", 88);
        } else if (string.equals("Copy")) {
            jMenuItem = this.createStandardItem(Platform.isMac() ? "Copy" : "Copy (c)", 67);
        } else if (string.equals("Paste")) {
            jMenuItem = this.createStandardItem(Platform.isMac() ? "Paste" : "Paste (v)", 86);
        } else if (string.equals("Save")) {
            jMenuItem = this.createStandardItem("Save", 83);
        } else if (string.equals("Save As")) {
            jMenuItem = this.createStandardItem("Save As...", 0);
        } else if (string.equals("Print")) {
            jMenuItem = this.createStandardItem("Print...", 80);
        } else if (string.equals("Print Console")) {
            jMenuItem = this.createStandardItem("Print Console", 0);
        } else if (string.equals("Script")) {
            jMenuItem = this.createStandardItem("Script...", 0);
        } else if (string.equals("Select All")) {
            jMenuItem = this.createStandardItem("Select All", 65);
        } else {
            throw new ErrorException("Illegal menu item: " + string);
        }
        jMenuItem.setActionCommand(string);
        jMenuItem.addActionListener(this.listener);
        return jMenuItem;
    }

    public Program getProgram() {
        return this.activeProgram;
    }

    public void setConsole(IOConsole iOConsole) {
        this.activeConsole = iOConsole;
    }

    public IOConsole getConsole() {
        return this.activeConsole;
    }

    public void setEnabled(String string, boolean bl) {
        int n = this.getMenuCount();
        int n2 = 0;
        while (n2 < n) {
            this.setEnabled(this.getMenu(n2), string, bl);
            ++n2;
        }
    }

    public MenuBar createOldStyleMenuBar() {
        MenuBar menuBar = new MenuBar();
        int n = this.getMenuCount();
        int n2 = 0;
        while (n2 < n) {
            menuBar.add(this.createOldStyleMenu(this.getMenu(n2)));
            ++n2;
        }
        return menuBar;
    }

    void setProgram(Program program) {
        this.activeProgram = program;
    }

    private JMenuItem createStandardItem(String string, int n) {
        JMenuItem jMenuItem = new JMenuItem(string);
        if (n != 0) {
            if (Platform.isMac()) {
                jMenuItem.setAccelerator(KeyStroke.getKeyStroke((int)((char)n), 2));
            } else {
                jMenuItem.setMnemonic(n);
            }
        }
        return jMenuItem;
    }

    private boolean patchModeInEffect(String string) {
        try {
            String string2 = this.getClass().getName();
            String string3 = string2.substring(0, string2.lastIndexOf(46) + 1);
            Class<?> clazz = Class.forName(String.valueOf(string3) + "JMenu");
            Class[] classArray = new Class[]{Class.forName("java.lang.String")};
            Object[] objectArray = new Object[]{string};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            JMenu jMenu = (JMenu)constructor.newInstance(objectArray);
            jMenu.setMnemonic(string.charAt(0));
            Class[] classArray2 = new Class[]{Class.forName("acm.program.ProgramMenuBar"), Class.forName("java.lang.String")};
            Object[] objectArray2 = new Object[]{this, "add" + string + "MenuItems"};
            Method method = clazz.getMethod("addViaCallback", classArray2);
            method.invoke((Object)jMenu, objectArray2);
            this.add(jMenu);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private Menu createOldStyleMenu(JMenu jMenu) {
        Menu menu = new Menu(jMenu.getText());
        int n = jMenu.getItemCount();
        int n2 = 0;
        while (n2 < n) {
            menu.add(this.createOldStyleMenuItem(jMenu.getItem(n2)));
            ++n2;
        }
        return menu;
    }

    private MenuItem createOldStyleMenuItem(Object object) {
        if (object == null) {
            return new MenuItem("-");
        }
        if (object instanceof JMenu) {
            return this.createOldStyleMenu((JMenu)object);
        }
        if (object instanceof JCheckBoxMenuItem) {
            return new OldStyleCheckBoxMenuItem((JCheckBoxMenuItem)object);
        }
        if (object instanceof JMenuItem) {
            return new OldStyleMenuItem((JMenuItem)object);
        }
        throw new ErrorException("Unsupported menu item type");
    }

    private void setEnabled(JMenu jMenu, String string, boolean bl) {
        JMenu jMenu2 = jMenu;
        int n = jMenu2.getItemCount();
        int n2 = 0;
        while (n2 < n) {
            JMenuItem jMenuItem = jMenu2.getItem(n2);
            if (jMenuItem != null) {
                this.setEnabled(jMenuItem, string, bl);
            }
            ++n2;
        }
    }

    private void setEnabled(JMenuItem jMenuItem, String string, boolean bl) {
        if (string.equals(jMenuItem.getActionCommand())) {
            jMenuItem.setEnabled(bl);
        }
    }
}

