import java.awt.*;
    
/** An instance is an HSV value. */
public class HSV {
    /** h, s, and v are the components of an HSV value */
    public double h; /* 0  h < 360 */
    public double s; /* 0  s  1 */
    public double v; /* 0  v  1 */
    
    /** Constructor: the tuple (h, s, v)
        Precondition: 0  h < 360, 0  s  1, 0  v  1.  */
    public HSV(double h, double s, double v) {
        this.h= h;
        this.s= s;
        this.v= v;
    }
    
    /** = this color in RGB color space
      formulae from http://en.wikipedia.org/wiki/HSV_color_space */
    public Color toRGB() {
        int Hi= (int)Math.floor(h / 60.0) % 6;
        
        double f= h / 60 - Hi;
        double p= v * (1.0 - s);
        double q= v * (1.0 - f * s);
        double t= v * (1.0 - (1.0 - f) * s);
        double R, G, B;
        
        if (Hi == 0) {
            R= v;  G= t;  B= p;
        }
        else if (Hi == 1) {
            R= q;  G= v;  B= p;
        }
        else if (Hi == 2) {
            R= p;  G= v;  B= t;
        }
        else if (Hi == 3) {
            R= p;  G= q;  B= v;
        }
        else if (Hi == 4) {
            R= t;  G= p;  B= v;
        }
        else { // {Hi == 5}
            R= v;  G= p;  B= q;
        }
        
        return new Color((int)Math.round(R * 255.0),
                         (int)Math.round(G * 255.0),
                         (int)Math.round(B * 255.0));
    }
}
