/*
 * Decompiled with CFR 0.152.
 */
package acm.graphics;

import acm.graphics.ArcRenderer;
import acm.graphics.GCanvas;
import acm.graphics.GMath;
import acm.graphics.GRect;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;

public class GRoundRect
extends GRect {
    public static final double DEFAULT_ARC = 10.0;
    private double aWidth;
    private double aHeight;
    private ArcRenderer renderer;

    public GRoundRect(double d, double d2) {
        this(0.0, 0.0, d, d2, 10.0);
    }

    public GRoundRect(double d, double d2, double d3, double d4) {
        this(d, d2, d3, d4, 10.0);
    }

    public GRoundRect(double d, double d2, double d3, double d4, double d5) {
        this(d, d2, d3, d4, d5, d5);
    }

    public GRoundRect(double d, double d2, double d3, double d4, double d5, double d6) {
        super(d, d2, d3, d4);
        this.aWidth = d5;
        this.aHeight = d6;
        this.renderer = new ArcRenderer(this);
    }

    public double getArcWidth() {
        return this.aWidth;
    }

    public double getArcHeight() {
        return this.aHeight;
    }

    public void paint(Graphics graphics) {
        Component component = this.getComponent();
        if (component instanceof GCanvas && !((GCanvas)component).getNativeArcFlag()) {
            this.renderer.draw(graphics);
        } else {
            Rectangle rectangle = this.getAWTBounds();
            int n = GMath.round(this.aWidth);
            int n2 = GMath.round(this.aHeight);
            if (this.isFilled()) {
                graphics.setColor(this.getFillColor());
                graphics.fillRoundRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height, n, n2);
                graphics.setColor(this.getColor());
            }
            graphics.drawRoundRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height, n, n2);
        }
    }
}

