/*
 * Decompiled with CFR 0.152.
 */
package acm.graphics;

import acm.graphics.GFillable;
import acm.graphics.GMath;
import acm.graphics.GObject;
import acm.graphics.GPoint;
import acm.graphics.GRectangle;
import acm.graphics.GScalable;
import acm.util.ErrorException;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Polygon;
import java.util.ArrayList;

public class GPolygon
extends GObject
implements GFillable,
GScalable {
    private static final double EPSILON = 1.0E-5;
    private double cx;
    private double cy;
    private double xScale;
    private double yScale;
    private double rotation;
    private ArrayList vertexList;
    private boolean cacheValid;
    private boolean complete;
    private Polygon poly;
    private Object lock;
    private boolean isFilled;
    private Color fillColor;

    public GPolygon() {
        this(0.0, 0.0);
    }

    public GPolygon(double d, double d2) {
        this.clear();
        this.lock = new Object();
        this.setLocation(d, d2);
    }

    public GPolygon(GPoint[] gPointArray) {
        this.clear();
        Object object = this.lock;
        synchronized (object) {
            int n = 0;
            while (n < gPointArray.length) {
                this.vertexList.add(new GPoint(gPointArray[n].getX(), gPointArray[n].getY()));
                ++n;
            }
        }
        this.markAsComplete();
        this.rotation = 0.0;
        this.xScale = 1.0;
        this.yScale = 1.0;
        this.lock = new Object();
        this.setLocation(0.0, 0.0);
    }

    public void addVertex(double d, double d2) {
        if (this.complete) {
            throw new ErrorException("You can't add vertices to a GPolygon that has been marked as complete.");
        }
        Object object = this.lock;
        synchronized (object) {
            this.vertexList.add(new GPoint(d, d2));
            this.cx = d;
            this.cy = d2;
        }
    }

    public void addEdge(double d, double d2) {
        if (this.complete) {
            throw new ErrorException("You can't add edges to a GPolygon that has been marked as complete.");
        }
        Object object = this.lock;
        synchronized (object) {
            this.cx += d;
            this.cy += d2;
            this.vertexList.add(new GPoint(this.cx, this.cy));
        }
    }

    public final void addPolarEdge(double d, double d2) {
        if (this.complete) {
            throw new ErrorException("You can't add edges to a GPolygon that has been marked as complete.");
        }
        Object object = this.lock;
        synchronized (object) {
            this.cx += d * GMath.cosDegrees(d2);
            this.cy -= d * GMath.sinDegrees(d2);
            this.vertexList.add(new GPoint(this.cx, this.cy));
        }
    }

    public void addArc(double d, double d2, double d3, double d4) {
        if (this.complete) {
            throw new ErrorException("You can't add edges to a GPolygon that has been marked as complete.");
        }
        Object object = this.lock;
        synchronized (object) {
            double d5 = d2 / d;
            double d6 = d / 2.0;
            double d7 = d2 / 2.0;
            double d8 = this.cx - d6 * GMath.cosDegrees(d3);
            double d9 = this.cy + d7 * GMath.sinDegrees(d3);
            if (d4 > 359.99) {
                d4 = 360.0;
            }
            if (d4 < -359.99) {
                d4 = -360.0;
            }
            double d10 = Math.atan2(1.0, Math.max(d, d2));
            int n = (int)(GMath.toRadians(Math.abs(d4)) / d10);
            d10 = GMath.toRadians(d4) / (double)n;
            double d11 = GMath.toRadians(d3);
            int n2 = 0;
            while (n2 < n) {
                double d12 = d8 + d6 * Math.cos(d11 += d10);
                double d13 = d9 - d6 * Math.sin(d11) * d5;
                this.addVertex(d12, d13);
                ++n2;
            }
        }
    }

    public GPoint getCurrentPoint() {
        return this.vertexList.isEmpty() ? null : new GPoint(this.cx, this.cy);
    }

    public void scale(double d, double d2) {
        this.xScale *= d;
        this.yScale *= d2;
        this.repaint();
    }

    public final void scale(double d) {
        this.scale(d, d);
    }

    public void rotate(double d) {
        this.rotation += d;
        this.repaint();
    }

    public void setFilled(boolean bl) {
        this.isFilled = bl;
        this.repaint();
    }

    public boolean isFilled() {
        return this.isFilled;
    }

    public void setFillColor(Color color) {
        this.fillColor = color;
        this.repaint();
    }

    public Color getFillColor() {
        return this.fillColor == null ? this.getColor() : this.fillColor;
    }

    public GRectangle getBounds() {
        int n = this.vertexList.size();
        if (n == 0) {
            return new GRectangle();
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        Object object = this.lock;
        synchronized (object) {
            double d5 = this.getX();
            double d6 = this.getY();
            double d7 = GMath.sinDegrees(this.rotation);
            double d8 = GMath.cosDegrees(this.rotation);
            boolean bl = true;
            int n2 = 0;
            while (n2 < this.vertexList.size()) {
                GPoint gPoint = (GPoint)this.vertexList.get(n2);
                double d9 = d5 + this.xScale * (d8 * gPoint.getX() + d7 * gPoint.getY());
                double d10 = d6 + this.yScale * (d8 * gPoint.getY() - d7 * gPoint.getX());
                if (bl) {
                    d = d9;
                    d2 = d9;
                    d3 = d10;
                    d4 = d10;
                    bl = false;
                } else {
                    d = Math.min(d, d9);
                    d2 = Math.max(d2, d9);
                    d3 = Math.min(d3, d10);
                    d4 = Math.max(d4, d10);
                }
                ++n2;
            }
        }
        return new GRectangle(d, d3, d2 - d, d4 - d3);
    }

    public boolean contains(double d, double d2) {
        return this.getPolygon().contains(GMath.round(d), GMath.round(d2));
    }

    public void paint(Graphics graphics) {
        if (this.vertexList.size() == 0) {
            return;
        }
        Polygon polygon = this.getPolygon();
        if (this.isFilled()) {
            graphics.setColor(this.getFillColor());
            graphics.fillPolygon(polygon.xpoints, polygon.ypoints, polygon.npoints);
            graphics.setColor(this.getColor());
        }
        graphics.drawPolygon(polygon.xpoints, polygon.ypoints, polygon.npoints);
    }

    public void recenter() {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        boolean bl = true;
        int n = 0;
        while (n < this.vertexList.size()) {
            GPoint gPoint = (GPoint)this.vertexList.get(n);
            if (bl) {
                d = gPoint.getX();
                d2 = gPoint.getX();
                d3 = gPoint.getY();
                d4 = gPoint.getY();
                bl = false;
            } else {
                d = Math.min(d, gPoint.getX());
                d2 = Math.max(d2, gPoint.getX());
                d3 = Math.min(d3, gPoint.getY());
                d4 = Math.max(d4, gPoint.getX());
            }
            ++n;
        }
        double d5 = (d + d2) / 2.0;
        double d6 = (d3 + d4) / 2.0;
        int n2 = 0;
        while (n2 < this.vertexList.size()) {
            GPoint gPoint = (GPoint)this.vertexList.get(n2);
            gPoint.translate(-d5, -d6);
            ++n2;
        }
        this.cacheValid = false;
    }

    public Object clone() {
        try {
            Object object = super.clone();
            ((GPolygon)object).copyVertexList();
            return object;
        }
        catch (Exception exception) {
            throw new ErrorException("Impossible exception");
        }
    }

    protected void repaint() {
        this.cacheValid = false;
        super.repaint();
    }

    protected Polygon getPolygon() {
        if (this.cacheValid) {
            return this.poly;
        }
        Object object = this.lock;
        synchronized (object) {
            double d = this.getX();
            double d2 = this.getY();
            double d3 = GMath.sinDegrees(this.rotation);
            double d4 = GMath.cosDegrees(this.rotation);
            this.poly = new Polygon();
            int n = 0;
            while (n < this.vertexList.size()) {
                GPoint gPoint = (GPoint)this.vertexList.get(n);
                double d5 = d + this.xScale * (d4 * gPoint.getX() + d3 * gPoint.getY());
                double d6 = d2 + this.yScale * (d4 * gPoint.getY() - d3 * gPoint.getX());
                this.poly.addPoint(GMath.round(d5), GMath.round(d6));
                ++n;
            }
            this.cacheValid = true;
            Polygon polygon = this.poly;
            Object var3_11 = null;
            return polygon;
        }
    }

    protected void markAsComplete() {
        this.complete = true;
    }

    protected void clear() {
        if (this.complete) {
            throw new ErrorException("You can't clear a GPolygon that has been marked as complete.");
        }
        this.vertexList = new ArrayList();
        this.cx = 0.0;
        this.cy = 0.0;
        this.rotation = 0.0;
        this.xScale = 1.0;
        this.yScale = 1.0;
        this.cacheValid = false;
    }

    private void copyVertexList() {
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n < this.vertexList.size()) {
            arrayList.add(this.vertexList.get(n));
            ++n;
        }
        this.vertexList = arrayList;
    }
}

