/** An instance represents a CMYK value */
public class CMYK {
    private double c; /** Color cyan. 0 <= c <= 100. */
    private double m; /** Color magenta. 0 <= m <= 100. */
    private double y; /** Color yellow. 0 <= y <= 100. */
    private double k; /** Color black. 0 <= c <= 100. */
    
    /** Constructor: the CMYK value (c, m, y, k).
      *  Precondition: All components c, m, y, and k are 
      *  >= 0 and <= 100.
      */
    public CMYK(double c, double m, double y, double k) {
        this.c= c;
        this.m= m;
        this.y= y;
        this.k= k;
    }
    
    /** A representation of this CMYK color. */
    public String toString() {
        return A4Methods.toString(this);
    }
    
    /** Yields: the cyan component of this CMYK value */
    public double cyan() {
        return c;
    }
    
    /** Yields: the magenta component of this CMYK value */
    public double magenta() {
        return m;
    }
    
     /** Yields: the yellow component of this CMYK value */
    public double yellow() {
        return y;
    }
    
    /** Yields: the black (K) component of this CMYK value */
    public double black() {
        return k;
    }

}
