import java.awt.*;

/** Contains static methods of assignment A4 */
public class A4Methods {
    
    /** Yields: the complement of color rgb. */
    public static Color complementRGB(Color rgb) {
        // Change this return statement into one that returns the complement
        return new Color(rgb.getRed(), rgb.getGreen(), rgb.getBlue());
    }
    
    
    /** = d, as a String, using exactly 5 characters.
      * Precondition: 0 <= d <= 999.
      * The truncated d will have one of the forms:
      *    ddd.d      Example:  360.1
      *    dd.dd      Example:  29.53
      *    d.ddd      Examples: 4.003,  0.001,  and 0.000
      */
    public static String truncateTo5(double d) {
        assert 0 <= d  && d <= 999;
        
        /* To get the desired output, do the following
        //   1. If d < 0.001, set d to 0.
        //      This prevents d appearing in scientific notation, e.g. 1.5E-6.
        //   2. Convert d to a string s, in the usual way. Note that s is guaranteed to
        //      have at least three chars: a decimal point and a digit on either side of it.
        //      Therefore, the simplest thing to do as s is being constructed is to make
        //      sure s has at least 5 chars is append "00".
        //   3. Return the first five characters of s.
        */
        return "";
    }
    
    /** Yields: d, but rounded (if necessary) to its first 5 characters.
      * Precondition: 0 <= d <= 360. Examples:
      *   Round 1.3546  to  1.355.
      *   Round 1.3544  to  1.354.
      *   Round 21.9954 to  22.00.
      *   Round 21.994  to  21.99.
      *   Round 130.59  to  130.6.
      *   Round 130.54  to  130.5.
      */
    public static String roundTo5(double d) {
        // Note. You want to round and then call truncateTo5. DO NOT convert d
        // to a string and then back to a double in order to call truncateTo5.
        // Points will be deducted for this.
        //    
        // Rounding to an integer is usually done by adding .5 and
        // truncating to an integer, right?
        //    E.g. Change 10.6 to 11.1 and truncate to 11
        //    E.g. Change 10.4 to 10.9 and truncate to 10
        // 
        // The difference here is that the rounding takes place at a different place
        // depending on how big d is, so that what one adds before truncating depends
        // on how big the number is initially. Look at the examples in the specification.
        //     If you don't understand, read the note at the end of this file.
        return "";
    }
    
    /** Yields: RGB value rgb in the form "(R, G, B)".
      * Precondition: each of the rgb values is an integer
      * in the range 0..255. 
      */
    public static String toString(Color rgb) {
        return "";
    }
    
    /** Yields: CMYK value cmyk in the form "(C, M, Y, K)". In the output,
      *   each of C, M, Y, and K should be exactly 5 characters long.
      * Precondition: All parameters are >= 0 and <= 100. 
      */
    public static String toString(CMYK cmyk) {
        return "";
    }
    
    /** Yields: HSV value rgb in the form "(H, S, V)". In the output,
      * each of H, S, and V should be exactly 5 characters long. 
      */
    public static String toString(HSV hsv) {
        return "";
    }
    
    /** Yields: color rgb in space CMYK, with the most black possible.
      * Formulae from en.wikipedia.org/wiki/CMYK_color_model.
      */
    public static CMYK convertRGBtoCMYK(Color rgb) {
        // The RGB numbers are in the range 0..255.
        // Change the RGB numbers to the range 0..1 by dividing them by 255.0.
        double R= rgb.getRed() / 255.0;
        double G= rgb.getGreen() / 255.0;
        double B= rgb.getBlue() / 255.0;
        
        // Don't forget the output CMYK values are supposed to be in the 
        // range 0.0..100.0.
        return new CMYK(0, 0, 0, 0);
    }
    
    /** Yields: color CMYK in space RGB.
      * Formulae from en.wikipedia.org/wiki/CMYK_color_model.
      */
    public static Color convertCMYKtoRGB(CMYK cmyk) {
        // The CMYK numbers are in the range 0.0..100.0.  Deal with them in the 
        // same way as the RGB numbers in RGB2CMYK().
        
        return new Color(0, 0, 0);
    }
    
    /** Yields: color rgb in HSV color space.
      * Formulae from wikipedia.org/wiki/HSV_color_space. 
      */
    public static HSV convertRGBtoHSV(Color rgb) {
        // The RGB numbers are in the range 0..255.
        // First change them to range 0..1 by dividing them by 2.55.0.
        double R= rgb.getRed() / 255.0;
        double G= rgb.getGreen() / 255.0;
        double B= rgb.getBlue() / 255.0;
    
        return new HSV(0, 0, 0);
    }
    
    /** Yields: color in RGB color space
      * Formulae from http://en.wikipedia.org/wiki/HSV_color_space 
      */
    public static Color convertHSVtoRGB(HSV HSV) {
        double H= HSV.hue();
        double S= HSV.sat();
        double V= HSV.val();
        
 
        
        return new Color(0, 0, 0);
    }
    
    /** NOTE ON roundTo5.The tendency is to try to convert d to a String so that the
      * period can be located, change the result a bit, convert back to a double, and call
      * truncateTo5. Resist this temptation!! It's clumsy and awkward.
      * 
      * Instead, just add something to d and then call truncateTo5 --what you add may
      * depend on the size of d.
      * 
      * Suppose d >= 100. Then, the five-character result will have the form xxx.x, where
      * the x's are digits. Ask yourself what you have to add to d so that truncating to 5
      * characters will then yield the right result. Here are two cases to consider:
      * 
      * d           after adding something and truncating to 5 digits
      * 321.4667    321.5
      * 321.4461    321.4
      * 
      * We could tell you what to add to d in this case, but then you don't learn yourself how to
      * solve little problems.
      * 
      * Besides d >= 100, there are two other cases to deal with: 10 <= d < 100  and 0 <= d < 10.
      */
}
