/** Demo on 1 March 2011 */
public class D {
    
    /** =  n, with commas every 3 digits.
      Precondition: n >= 0.
      e.g. commafy(5341267) = 5,341,267 */
    public static String commafy(int n) {
        if (n < 1000) return "" + n;
        // n >= 1000
        return  commafy(n/1000)  + ","  + to3(n%1000);
    }
    
    /** = p with at least 3 chars --add leading 0's if necessary */
    public static String to3(int p) {
        if (p < 10) return "00" + p;
        if (p < 100) return "0" + p;
        return "" + p;
    }
    
    /** =  b^c. Precondition: c  0
           Property. b^c =  b * b^(c-1)*/
    public static double expSlow(double b, int c) {
        if (c == 0)
            return 1;
        // c > 0
        return b * expSlow(b, c-1);
    }
    
    /** =  b^c. Precondition: c  0
           Property. b^c =  b * b^(c-1)
           Property. b^c = (b*b)^(c/2) for even c*/
    public static double expFast(double b, int c) {
        if (c == 0) 
            return 1;
        
        // c > 0
        if (c%2 == 0) 
            return expFast(b*b, c/2);
        
        return b * expFast(b, c-1);

    }
    
    // The following two methods produce a pair
    // (value of b^c, number of calls made to produce the value)
    // They use class PairDi to aggregate the two values into an object.
    // We could say that the object wraps the two vallues.
    
    /** =  the pair (b^c, no. of calls made).
           Precondition: c  0.
           Property: b^c = b * b^(c-1) */
    public static PairDI exp1Slow(double b, int c) {
        if (c == 0) 
            return new PairDI(1.0, 1);
        
        // c > 0
        PairDI p= exp1Slow(b, c-1);
        return new PairDI(b * p.d, p.i+1);
    }
    
    /** =  the pair (b^c, no. of calls made).
           Precondition: c  0*/
    public static PairDI exp1Fast(double b, int c) {
        if (c == 0) 
            return new PairDI(1.0, 1);
            
        // c > 0
        if (c % 2 == 0) {
            PairDI p= exp1Fast(b*b, c/2);
            return new PairDI(p.d, p.i+1);
        }
        
        // c is odd
        PairDI p= exp1Fast(b, c-1);
        return new PairDI(b * p.d, p.i+1);
    }
    
}