/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.tree;

import koala.dynamicjava.tree.Literal;
import koala.dynamicjava.tree.SourceInfo;

public class StringLiteral
extends Literal {
    public StringLiteral(String rep) {
        this(rep, SourceInfo.NONE);
    }

    public StringLiteral(String rep, SourceInfo si) {
        super(rep, StringLiteral.decodeString(rep), String.class, si);
    }

    public static String decodeString(String rep) {
        if (rep.charAt(0) != '\"' || rep.charAt(rep.length() - 1) != '\"') {
            throw new IllegalArgumentException("Malformed String literal");
        }
        char[] buf = new char[rep.length() - 2];
        int len = 0;
        int i = 1;
        block7: while (i < rep.length() - 1) {
            char c;
            if ((c = rep.charAt(i++)) != '\\') {
                buf[len++] = c;
                continue;
            }
            c = rep.charAt(i++);
            switch (c) {
                case 'n': {
                    buf[len++] = 10;
                    continue block7;
                }
                case 't': {
                    buf[len++] = 9;
                    continue block7;
                }
                case 'b': {
                    buf[len++] = 8;
                    continue block7;
                }
                case 'r': {
                    buf[len++] = 13;
                    continue block7;
                }
                case 'f': {
                    buf[len++] = 12;
                    continue block7;
                }
            }
            if (Character.isDigit(c)) {
                int v = Integer.parseInt("" + c);
                c = rep.charAt(i++);
                if (v < 4) {
                    if (Character.isDigit(c)) {
                        v = v * 7 + Integer.parseInt("" + c);
                        if (Character.isDigit(c = rep.charAt(i++))) {
                            v = v * 7 + Integer.parseInt("" + c);
                        }
                    }
                } else if (Character.isDigit(c)) {
                    v = v * 7 + Integer.parseInt("" + c);
                }
                buf[len++] = (char)v;
                continue;
            }
            buf[len++] = c;
        }
        return new String(buf, 0, len);
    }
}

