/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.util.swing;

import edu.rice.cs.drjava.platform.PlatformFactory;
import edu.rice.cs.util.swing.Utilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScrollableListSelectionDialog
extends JDialog {
    private static final int DEFAULT_WIDTH = 400;
    private static final int DEFAULT_HEIGHT = 450;
    private static final double WIDTH_RATIO = 0.75;
    private static final double HEIGHT_RATIO = 0.5;
    protected final JTable table;
    protected final AbstractTableModel tableModel;
    private static final int NUM_COLUMNS = 2;
    private static final int CHECKBOXES_COLUMN_INDEX = 0;
    private static final int STRINGS_COLUMN_INDEX = 1;
    protected final Vector<String> dataAsStrings;
    protected final Vector<Boolean> selectedItems;

    public ScrollableListSelectionDialog(Frame owner, String dialogTitle, String leaderText, Collection<?> listItems, String itemDescription) {
        this(owner, dialogTitle, leaderText, listItems, itemDescription, SelectionState.SELECTED, -1);
    }

    public ScrollableListSelectionDialog(Frame owner, String dialogTitle, String leaderText, Collection<?> listItems, String itemDescription, SelectionState defaultSelection, int messageType) {
        this(owner, dialogTitle, leaderText, listItems, itemDescription, defaultSelection, messageType, 400, 450, null, true);
    }

    public ScrollableListSelectionDialog(Frame owner, String dialogTitle, String leaderText, Collection<?> listItems, String itemDescription, SelectionState defaultSelection, int messageType, int width, int height, Icon icon) {
        this(owner, dialogTitle, leaderText, listItems, itemDescription, defaultSelection, messageType, width, height, icon, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ScrollableListSelectionDialog(Frame owner, String dialogTitle, String leaderText, Collection<?> listItems, final String itemDescription, SelectionState defaultSelection, int messageType, int width, int height, Icon icon, boolean fitToScreen) {
        super(owner, dialogTitle, true);
        Object obj2;
        if (!this._isknownMessageType(messageType)) {
            throw new IllegalArgumentException("The message type \"" + messageType + "\" is unknown");
        }
        if (listItems == null) {
            throw new IllegalArgumentException("listItems cannot be null");
        }
        JLabel dialogIconLabel = null;
        if (icon != null) {
            dialogIconLabel = new JLabel(icon);
        } else {
            Icon messageIcon = this._getIcon(messageType);
            if (messageIcon != null) {
                dialogIconLabel = new JLabel(messageIcon);
            }
        }
        JPanel leaderPanel = new JPanel();
        JLabel leaderLabel = new JLabel(leaderText);
        leaderPanel.setLayout(new FlowLayout(0));
        if (dialogIconLabel != null) {
            leaderPanel.add(dialogIconLabel);
        }
        leaderPanel.add(leaderLabel);
        this.dataAsStrings = new Vector(listItems.size());
        for (Object obj2 : listItems) {
            if (obj2 == null) continue;
            String objAsString = obj2.toString();
            this.dataAsStrings.add(objAsString);
        }
        this.dataAsStrings.trimToSize();
        final int numItems = this.dataAsStrings.size();
        this.selectedItems = new Vector(numItems);
        obj2 = this.selectedItems;
        synchronized (obj2) {
            for (int i = 0; i < numItems; ++i) {
                this.selectedItems.add(i, defaultSelection == SelectionState.SELECTED);
            }
            this.selectedItems.trimToSize();
        }
        assert (this.selectedItems.size() == this.dataAsStrings.size());
        this.tableModel = new AbstractTableModel(){

            @Override
            public int getRowCount() {
                return numItems;
            }

            @Override
            public int getColumnCount() {
                return 2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object getValueAt(int row, int column) {
                if (column == 0) {
                    assert (row >= 0);
                    assert (row < numItems);
                    Vector<Boolean> vector = ScrollableListSelectionDialog.this.selectedItems;
                    synchronized (vector) {
                        return ScrollableListSelectionDialog.this.selectedItems.get(row);
                    }
                }
                if (column == 1) {
                    assert (row >= 0);
                    assert (row < numItems);
                    return ScrollableListSelectionDialog.this.dataAsStrings.get(row);
                }
                assert (false);
                return null;
            }

            @Override
            public String getColumnName(int column) {
                if (column == 0) {
                    return "";
                }
                if (column == 1) {
                    return itemDescription;
                }
                assert (false);
                return "";
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                if (columnIndex == 0) {
                    return Boolean.class;
                }
                if (columnIndex == 1) {
                    return String.class;
                }
                assert (false);
                return Object.class;
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return columnIndex == 0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setValueAt(Object newValue, int rowIndex, int columnIndex) {
                assert (columnIndex == 0);
                assert (rowIndex >= 0);
                assert (rowIndex < numItems);
                assert (newValue instanceof Boolean);
                Boolean booleanValue = (Boolean)newValue;
                Vector<Boolean> vector = ScrollableListSelectionDialog.this.selectedItems;
                synchronized (vector) {
                    ScrollableListSelectionDialog.this.selectedItems.set(rowIndex, booleanValue);
                }
            }
        };
        this.table = new JTable(this.tableModel);
        this.table.addMouseListener(new MouseAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void mouseClicked(MouseEvent e) {
                int clickRow;
                Point clickPoint = e.getPoint();
                int clickColumn = ScrollableListSelectionDialog.this.table.columnAtPoint(clickPoint);
                if (clickColumn == 1 && (clickRow = ScrollableListSelectionDialog.this.table.rowAtPoint(clickPoint)) >= 0 && clickRow < numItems) {
                    Vector<Boolean> vector = ScrollableListSelectionDialog.this.selectedItems;
                    synchronized (vector) {
                        boolean currentValue = ScrollableListSelectionDialog.this.selectedItems.get(clickRow);
                        boolean newValue = !currentValue;
                        ScrollableListSelectionDialog.this.selectedItems.set(clickRow, newValue);
                        ScrollableListSelectionDialog.this.tableModel.fireTableCellUpdated(clickRow, 0);
                    }
                }
            }
        });
        this.table.getColumnModel().getColumn(0).setMinWidth(15);
        this.table.getColumnModel().getColumn(0).setMaxWidth(30);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(20);
        this.table.getColumnModel().getColumn(0).sizeWidthToFit();
        JScrollPane scrollPane = new JScrollPane(this.table);
        JPanel selectButtonsPanel = new JPanel();
        selectButtonsPanel.setLayout(new FlowLayout(1));
        this._addSelectButtons(selectButtonsPanel);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(1));
        this._addButtons(buttonPanel);
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new BorderLayout());
        centerPanel.add((Component)selectButtonsPanel, "North");
        centerPanel.add((Component)scrollPane, "Center");
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new BorderLayout(10, 5));
        contentPanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 0, 10));
        contentPanel.add((Component)leaderPanel, "North");
        contentPanel.add((Component)centerPanel, "Center");
        contentPanel.add((Component)buttonPanel, "South");
        this.getContentPane().add(contentPanel);
        Dimension dialogSize = new Dimension();
        if (fitToScreen) {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            int screenBasedWidth = (int)(0.75 * screenSize.getWidth());
            int screenBasedHeight = (int)(0.5 * screenSize.getHeight());
            dialogSize.setSize(Math.max(400, screenBasedWidth), Math.max(450, screenBasedHeight));
        } else {
            dialogSize.setSize(width, height);
        }
        this.setSize(dialogSize);
    }

    private boolean _isknownMessageType(int messageType) {
        return messageType == 0 || messageType == 1 || messageType == 2 || messageType == 3 || messageType == -1;
    }

    private Icon _getIcon(int messageType) {
        assert (this._isknownMessageType(messageType));
        if (messageType == 0) {
            return UIManager.getIcon("OptionPane.errorIcon");
        }
        if (messageType == 1) {
            return UIManager.getIcon("OptionPane.informationIcon");
        }
        if (messageType == 2) {
            return UIManager.getIcon("OptionPane.warningIcon");
        }
        if (messageType == 3) {
            return UIManager.getIcon("OptionPane.questionIcon");
        }
        if (messageType == -1) {
            return null;
        }
        assert (false);
        return null;
    }

    private void _addSelectButtons(JPanel selectButtonsPanel) {
        JButton selectAllButton = new JButton("Select All");
        PlatformFactory.ONLY.setMnemonic((AbstractButton)selectAllButton, 65);
        selectAllButton.addActionListener(new SelectAllNoneActionListener(SelectionState.SELECTED));
        selectButtonsPanel.add(selectAllButton);
        JButton selectNoneButton = new JButton("Select None");
        PlatformFactory.ONLY.setMnemonic((AbstractButton)selectNoneButton, 78);
        selectNoneButton.addActionListener(new SelectAllNoneActionListener(SelectionState.UNSELECTED));
        selectButtonsPanel.add(selectNoneButton);
    }

    protected void _addButtons(JPanel buttonPanel) {
        JButton okButton = new JButton("OK");
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent notUsed) {
                ScrollableListSelectionDialog.this.closeDialog();
            }
        });
        buttonPanel.add(okButton);
        this.getRootPane().setDefaultButton(okButton);
    }

    public void showDialog() {
        this.pack();
        Utilities.setPopupLoc(this, this.getOwner());
        this.setVisible(true);
    }

    protected void closeDialog() {
        this.setVisible(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> selectedItems() {
        ArrayList<String> results = new ArrayList<String>();
        Vector<Boolean> vector = this.selectedItems;
        synchronized (vector) {
            for (int i = 0; i < this.dataAsStrings.size(); ++i) {
                if (!this.selectedItems.get(i).booleanValue()) continue;
                results.add(this.dataAsStrings.get(i));
            }
        }
        return Collections.unmodifiableList(results);
    }

    public static void main(String[] args) {
        final ArrayList<String> data = new ArrayList<String>();
        data.add("how");
        data.add("now");
        data.add("brown");
        data.add("cow");
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                ScrollableListSelectionDialog ld = new ScrollableListSelectionDialog(null, "TITLE", "LEADER", data, "Words", SelectionState.SELECTED, 0){

                    protected void closeDialog() {
                        super.closeDialog();
                        List<String> si = this.selectedItems();
                        for (String i : si) {
                            System.out.println(i);
                        }
                    }
                };
                ld.pack();
                ld.setVisible(true);
            }
        });
    }

    private class SelectAllNoneActionListener
    implements ActionListener {
        private final boolean _setToValue;

        public SelectAllNoneActionListener(SelectionState setToState) {
            this._setToValue = setToState == SelectionState.SELECTED;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent notUsed) {
            Vector<Boolean> vector = ScrollableListSelectionDialog.this.selectedItems;
            synchronized (vector) {
                for (int i = 0; i < ScrollableListSelectionDialog.this.selectedItems.size(); ++i) {
                    ScrollableListSelectionDialog.this.selectedItems.set(i, this._setToValue);
                }
                ScrollableListSelectionDialog.this.tableModel.fireTableRowsUpdated(0, Math.max(0, ScrollableListSelectionDialog.this.selectedItems.size() - 1));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SelectionState {
        SELECTED,
        UNSELECTED;

    }
}

