/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.util;

import edu.rice.cs.util.UnexpectedException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.Properties;

public class MD5ChecksumProperties
extends Properties {
    public static final int BUFFER_SIZE = 10240;

    public MD5ChecksumProperties() {
    }

    public MD5ChecksumProperties(Properties p) {
        super(p);
    }

    public static byte[] getMD5(InputStream is, OutputStream os) throws IOException {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            DigestInputStream dis = new DigestInputStream(new BufferedInputStream(is), digest);
            BufferedOutputStream bos = null;
            if (os != null) {
                bos = new BufferedOutputStream(os);
            }
            byte[] buf = new byte[10240];
            int bytesRead = 0;
            while ((bytesRead = dis.read(buf, 0, 10240)) != -1) {
                if (os == null) continue;
                bos.write(buf, 0, bytesRead);
            }
            if (os != null) {
                bos.flush();
            }
            dis.close();
            is.close();
            return digest.digest();
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new UnexpectedException(nsae, "MD5 algorithm not available");
        }
    }

    public static byte[] getMD5(InputStream is) throws IOException {
        return MD5ChecksumProperties.getMD5(is, null);
    }

    public static String getMD5String(InputStream is, OutputStream os) throws IOException {
        byte[] messageDigest = MD5ChecksumProperties.getMD5(is, os);
        StringBuilder hexString = new StringBuilder();
        for (int i = 0; i < messageDigest.length; ++i) {
            String oneByte = "0" + Integer.toHexString(0xFF & messageDigest[i]);
            hexString.append(oneByte.substring(oneByte.length() - 2, oneByte.length()));
        }
        return hexString.toString();
    }

    public static String getMD5String(InputStream is) throws IOException {
        return MD5ChecksumProperties.getMD5String(is, null);
    }

    public static byte[] getMD5(File f) throws IOException {
        return MD5ChecksumProperties.getMD5(new FileInputStream(f));
    }

    public static String getMD5String(File f) throws IOException {
        return MD5ChecksumProperties.getMD5String(new FileInputStream(f));
    }

    public static byte[] getMD5(byte[] b) throws IOException {
        return MD5ChecksumProperties.getMD5(new ByteArrayInputStream(b));
    }

    public static String getMD5String(byte[] b) throws IOException {
        return MD5ChecksumProperties.getMD5String(new ByteArrayInputStream(b));
    }

    public boolean addMD5(String key, InputStream is, OutputStream os) throws IOException {
        String md5 = MD5ChecksumProperties.getMD5String(is, os);
        Object prev = this.setProperty(key, md5);
        return prev == null || prev.equals(md5);
    }

    public boolean addMD5(String key, InputStream is) throws IOException {
        return this.addMD5(key, is, null);
    }

    public boolean addMD5(String key, File f, OutputStream os) throws IOException {
        return this.addMD5(key, new FileInputStream(f), os);
    }

    public boolean addMD5(String key, File f) throws IOException {
        return this.addMD5(key, f, null);
    }

    public boolean addMD5(String key, byte[] b, OutputStream os) throws IOException {
        return this.addMD5(key, new ByteArrayInputStream(b), os);
    }

    public boolean addMD5(String key, byte[] b) throws IOException {
        return this.addMD5(key, b, null);
    }

    public boolean addMD5(File f, OutputStream os) throws IOException {
        return this.addMD5(f.getPath().replace('\\', '/'), f, os);
    }

    public boolean addMD5(File f) throws IOException {
        return this.addMD5(f, null);
    }

    public static void main(String[] args) throws IOException {
        String line;
        FileInputStream pis;
        File outFile;
        InputStream is = System.in;
        OutputStream os = System.out;
        Properties prevp = new Properties();
        if (args.length == 2) {
            outFile = new File(args[1]);
            if (outFile.exists()) {
                pis = new FileInputStream(outFile);
                prevp.load(pis);
                pis.close();
            }
            is = new FileInputStream(new File(args[0]));
            os = new FileOutputStream(outFile);
        } else if (args.length == 1) {
            outFile = new File(args[0]);
            if (outFile.exists()) {
                pis = new FileInputStream(outFile);
                prevp.load(pis);
                pis.close();
            }
            os = new FileOutputStream(outFile);
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        MD5ChecksumProperties p = new MD5ChecksumProperties();
        p.putAll((Map<?, ?>)prevp);
        while ((line = br.readLine()) != null && !line.equals("")) {
            p.addMD5(new File(line));
        }
        p.store(os, "MD5 Checksums");
    }
}

