/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.concurrent;

import edu.rice.cs.plt.concurrent.JVMBuilder;
import edu.rice.cs.plt.concurrent.TaskController;
import edu.rice.cs.plt.debug.DebugUtil;
import edu.rice.cs.plt.io.IOUtil;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.lambda.Runnable1;
import edu.rice.cs.plt.lambda.Thunk;
import edu.rice.cs.plt.lambda.WrappedException;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.concurrent.Executor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessTaskController<R>
extends TaskController<R> {
    private JVMBuilder _jvmBuilder;
    private Executor _executor;
    private Thunk<? extends R> _task;
    private Runnable1<? super Process> _onExit;
    private volatile Thread _t;

    public ProcessTaskController(JVMBuilder jvmBuilder, Executor executor, Thunk<? extends R> task) {
        this._jvmBuilder = jvmBuilder;
        this._executor = executor;
        this._task = task;
        this._onExit = null;
        this._t = null;
    }

    public ProcessTaskController(JVMBuilder jvmBuilder, Executor executor, Thunk<? extends R> task, Runnable1<? super Process> onExit) {
        this._jvmBuilder = jvmBuilder;
        this._executor = executor;
        this._task = task;
        this._onExit = onExit;
        this._t = null;
    }

    @Override
    protected void doStart() {
        this._executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                ProcessTaskController.this._t = Thread.currentThread();
                ProcessTaskController.this.started();
                try {
                    if (Thread.interrupted()) {
                        throw new InterruptedException();
                    }
                    Process p = ProcessTaskController.this._jvmBuilder.start(Runner.class.getName(), IterUtil.empty());
                    try {
                        InputStream in = p.getInputStream();
                        int matching = 0;
                        while (matching < Runner.PREFIX.length) {
                            int read = in.read();
                            if (read == -1) {
                                throw new EOFException("Data prefix not found");
                            }
                            if ((byte)read == Runner.PREFIX[matching]) {
                                ++matching;
                                continue;
                            }
                            if ((byte)read == Runner.PREFIX[0]) {
                                matching = 1;
                                continue;
                            }
                            matching = 0;
                        }
                        ObjectOutputStream objOut = new ObjectOutputStream(p.getOutputStream());
                        try {
                            objOut.writeObject(ProcessTaskController.this._task);
                        }
                        finally {
                            objOut.close();
                        }
                        ObjectInputStream objIn = new ObjectInputStream(in);
                        try {
                            Object result = objIn.readObject();
                            Exception taskE = (Exception)objIn.readObject();
                            RuntimeException implementationE = (RuntimeException)objIn.readObject();
                            if (implementationE != null) {
                                p.destroy();
                                ProcessTaskController.this.finishedWithImplementationException(implementationE);
                            } else if (taskE != null) {
                                p.destroy();
                                ProcessTaskController.this.finishedWithTaskException(taskE);
                            } else {
                                Runnable1 onExit = ProcessTaskController.this._onExit;
                                ProcessTaskController.this.finishedCleanly(result);
                                if (onExit != null) {
                                    p.waitFor();
                                    onExit.run(p);
                                }
                            }
                        }
                        finally {
                            objIn.close();
                        }
                    }
                    catch (EOFException e) {
                        throw new IOException("Unable to run process; class path may need to be adjusted");
                    }
                    finally {
                        p.destroy();
                    }
                }
                catch (InterruptedException e) {
                    ProcessTaskController.this.stopped();
                }
                catch (InterruptedIOException e) {
                    ProcessTaskController.this.stopped();
                }
                catch (RuntimeException e) {
                    ProcessTaskController.this.finishedWithImplementationException(e);
                }
                catch (Throwable t) {
                    ProcessTaskController.this.finishedWithImplementationException(new WrappedException(t));
                }
            }
        });
    }

    @Override
    protected void doStop() {
        this._t.interrupt();
    }

    @Override
    protected void discard() {
        this._jvmBuilder = null;
        this._executor = null;
        this._task = null;
        this._onExit = null;
        this._t = null;
    }

    private static class Runner {
        public static final byte[] PREFIX = new byte[]{0, 3, 127, -128};

        private Runner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void main(String ... args) {
            PrintStream out = System.out;
            IOUtil.attemptClose(System.err);
            IOUtil.ignoreSystemOut();
            IOUtil.ignoreSystemErr();
            try {
                ((OutputStream)out).write(PREFIX);
                ((OutputStream)out).flush();
                ObjectOutputStream objOut = new ObjectOutputStream(out);
                try {
                    Object result = null;
                    Exception taskException = null;
                    RuntimeException internalException = null;
                    try {
                        ObjectInputStream objIn = new ObjectInputStream(System.in);
                        try {
                            Thunk task = (Thunk)objIn.readObject();
                            try {
                                result = task.value();
                            }
                            catch (Exception e) {
                                taskException = e;
                            }
                        }
                        finally {
                            objIn.close();
                        }
                    }
                    catch (RuntimeException e) {
                        internalException = e;
                    }
                    catch (Throwable t) {
                        internalException = new WrappedException(t);
                    }
                    objOut.writeObject(result);
                    objOut.writeObject(taskException);
                    objOut.writeObject(internalException);
                }
                finally {
                    objOut.close();
                }
            }
            catch (IOException e) {
                DebugUtil.error.log("Error writing to System.out", e);
            }
        }
    }
}

