/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.concurrent;

import edu.rice.cs.plt.tuple.IdentityWrapper;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LockMap<T> {
    private final WeakHashMap<IdentityWrapper<T>, ReentrantLock> _map;

    public LockMap() {
        this._map = new WeakHashMap();
    }

    public LockMap(int initialCapacity) {
        this._map = new WeakHashMap(initialCapacity);
    }

    public synchronized ReentrantLock get(T val) {
        IdentityWrapper<T> key = IdentityWrapper.make(val);
        if (!this._map.containsKey(key)) {
            this._map.put(key, new ReentrantLock());
        }
        return this._map.get(key);
    }

    public Runnable lock(T val) {
        ReentrantLock l = this.get(val);
        Unlocker result = new Unlocker(l);
        l.lock();
        return result;
    }

    private static class Unlocker
    implements Runnable {
        private final ReentrantLock _l;

        public Unlocker(ReentrantLock l) {
            this._l = l;
        }

        public void run() {
            this._l.unlock();
        }
    }
}

