/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.javalanglevels;

import edu.rice.cs.javalanglevels.Augmentor;
import edu.rice.cs.javalanglevels.FullJavaVisitor;
import edu.rice.cs.javalanglevels.IntermediateVisitor;
import edu.rice.cs.javalanglevels.JExprParseException;
import edu.rice.cs.javalanglevels.LanguageLevelVisitor;
import edu.rice.cs.javalanglevels.Options;
import edu.rice.cs.javalanglevels.Pair;
import edu.rice.cs.javalanglevels.SourceInfo;
import edu.rice.cs.javalanglevels.SymbolData;
import edu.rice.cs.javalanglevels.Symboltable;
import edu.rice.cs.javalanglevels.Triple;
import edu.rice.cs.javalanglevels.TypeChecker;
import edu.rice.cs.javalanglevels.parser.JExprParser;
import edu.rice.cs.javalanglevels.parser.ParseException;
import edu.rice.cs.javalanglevels.tree.ClassDef;
import edu.rice.cs.javalanglevels.tree.JExpressionIF;
import edu.rice.cs.javalanglevels.tree.JExpressionIFAbstractVisitor;
import edu.rice.cs.javalanglevels.tree.NullLiteral;
import edu.rice.cs.javalanglevels.tree.SourceFile;
import edu.rice.cs.javalanglevels.tree.TypeDefBase;
import edu.rice.cs.javalanglevels.util.Log;
import edu.rice.cs.javalanglevels.util.Utilities;
import edu.rice.cs.plt.io.IOUtil;
import edu.rice.cs.plt.reflect.JavaVersion;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LanguageLevelConverter {
    public static final Log _log = new Log("LLConverter.txt", false);
    public static final Symboltable symbolTable = new Symboltable();
    public static Options OPT = Options.DEFAULT;
    private static final boolean SAFE_SUPPORT_CODE = false;
    public static final int INPUT_BUFFER_SIZE = 8192;
    public static final int LINE_NUM_MAPPINGS_PER_LINE = 8;
    public static final Hashtable<SymbolData, LanguageLevelVisitor> _newSDs = new Hashtable();
    private LinkedList<JExprParseException> _parseExceptions = new LinkedList();
    private LinkedList<Pair<String, JExpressionIF>> _visitorErrors = new LinkedList();

    private void _addParseException(ParseException pe) {
        JExprParseException jpe = pe instanceof JExprParseException ? (JExprParseException)pe : new JExprParseException(pe);
        this._parseExceptions.addLast(jpe);
    }

    private void _addVisitorError(Pair<String, JExpressionIF> ve) {
        this._visitorErrors.addLast(ve);
    }

    public Pair<LinkedList<JExprParseException>, LinkedList<Pair<String, JExpressionIF>>> convert(File[] files, Options options) {
        Hashtable<File, Set<String>> sourceToTopLevelClassMap = new Hashtable<File, Set<String>>();
        return this.convert(files, options, sourceToTopLevelClassMap);
    }

    /*
     * WARNING - void declaration
     */
    public Pair<LinkedList<JExprParseException>, LinkedList<Pair<String, JExpressionIF>>> convert(File[] files, Options options, Map<File, Set<String>> sourceToTopLevelClassMap) {
        File f;
        SourceFile sf;
        LanguageLevelVisitor llv;
        void var14_19;
        _log.log("LanguageLevelConverter.convert called on files:  " + Arrays.toString(files));
        OPT = options;
        assert (symbolTable != null);
        symbolTable.clear();
        _newSDs.clear();
        LinkedList<Pair<String, JExpressionIF>> languageLevelVisitorErrors = new LinkedList<Pair<String, JExpressionIF>>();
        Hashtable<String, Pair<SourceInfo, LanguageLevelVisitor>> continuations = new Hashtable<String, Pair<SourceInfo, LanguageLevelVisitor>>();
        LinkedList<Pair<LanguageLevelVisitor, SourceFile>> languageLevelVisitedFiles = new LinkedList<Pair<LanguageLevelVisitor, SourceFile>>();
        Hashtable mediator = new Hashtable();
        LinkedList<Triple<FullJavaVisitor, SourceFile, File>> visited = new LinkedList<Triple<FullJavaVisitor, SourceFile, File>>();
        LinkedList<Triple> toAugment = new LinkedList<Triple>();
        LinkedList<File> advanced = new LinkedList<File>();
        LinkedList<File> javaFiles = new LinkedList<File>();
        File[] arr$ = files;
        int len$ = arr$.length;
        boolean bl = false;
        while (var14_19 < len$) {
            block38: {
                File f2 = arr$[var14_19];
                try {
                    FullJavaVisitor llv2;
                    SourceFile sf2;
                    BufferedReader tempBr = new BufferedReader(new FileReader(f2));
                    String firstLine = tempBr.readLine();
                    tempBr.close();
                    if (firstLine == null) break block38;
                    if (LanguageLevelConverter.isAdvancedFile(f2)) {
                        advanced.addLast(f2);
                    } else if (LanguageLevelConverter.isFullJavaFile(f2)) {
                        javaFiles.addLast(f2);
                    }
                    if (!LanguageLevelConverter.isJavaFile(f2)) break block38;
                    System.out.flush();
                    JExprParser jep = new JExprParser(f2);
                    try {
                        _log.log("Parsing " + f2);
                        sf2 = jep.SourceFile();
                        final HashSet topLevelClasses = new HashSet();
                        for (TypeDefBase t : sf2.getTypes()) {
                            t.visit(new JExpressionIFAbstractVisitor<Void>(){

                                @Override
                                public Void forClassDef(ClassDef that) {
                                    topLevelClasses.add(that.getName().getText());
                                    return null;
                                }

                                @Override
                                public Void defaultCase(JExpressionIF that) {
                                    return null;
                                }
                            });
                        }
                        sourceToTopLevelClassMap.put(f2, topLevelClasses);
                    }
                    catch (ParseException pe) {
                        this._addParseException(pe);
                        _log.log("GENERATED ParseException for file " + f2);
                        break block38;
                    }
                    if (LanguageLevelConverter.isLanguageLevelFile(f2)) {
                        IntermediateVisitor llv22 = new IntermediateVisitor(f2, new LinkedList<Pair<String, JExpressionIF>>(), new Hashtable<String, Pair<SourceInfo, LanguageLevelVisitor>>(), languageLevelVisitedFiles);
                    } else {
                        assert (LanguageLevelConverter.isAdvancedFile(f2) || LanguageLevelConverter.isFullJavaFile(f2));
                        llv2 = new FullJavaVisitor(f2, new LinkedList<Pair<String, JExpressionIF>>(), new Hashtable<String, Pair<SourceInfo, LanguageLevelVisitor>>(), languageLevelVisitedFiles);
                    }
                    sf2.visit(llv2);
                    _log.log("\nDUMPING SYMBOLTABLE AFTER PHASE 1 PROCESSING OF " + f2 + "\n\n" + symbolTable + "\n");
                    visited.add(new Triple<FullJavaVisitor, SourceFile, File>(llv2, sf2, f2));
                    _log.log("\nCONTINUATIONS AFTER PHASE 1 PROCESSING OF " + f2 + "\n\n" + LanguageLevelVisitor.continuations + "\n");
                    _log.log("\nERRORS AFTER PHASE 1 PROCESSING OF " + f2 + "\n\n" + LanguageLevelVisitor.errors + "\n");
                    continuations.putAll(LanguageLevelVisitor.continuations);
                    languageLevelVisitorErrors.addAll(LanguageLevelVisitor.errors);
                }
                catch (IOException ioe) {
                    this._addVisitorError(new Pair<String, JExpressionIF>(ioe.getMessage(), new NullLiteral(SourceInfo.NO_INFO)));
                }
            }
            ++var14_19;
        }
        LanguageLevelVisitor.errors = new LinkedList();
        _log.log("\nDUMPING SYMBOLTABLE BEFORE CONTINUATION RESOLUTION\n\n" + symbolTable + "\n");
        _log.log("Resolving continuations: " + continuations + "\n");
        while (!continuations.isEmpty()) {
            Enumeration en = continuations.keys();
            while (en.hasMoreElements()) {
                String className = (String)en.nextElement();
                Pair pair = (Pair)continuations.remove(className);
                SymbolData returnedSd = ((LanguageLevelVisitor)pair.getSecond()).getSymbolData(className, (SourceInfo)pair.getFirst(), true);
                _log.log("Attempting to resolve " + className + "\n  Result = " + returnedSd);
                if (returnedSd != null) continue;
                LanguageLevelVisitor.errors.add(new Pair<String, NullLiteral>("Converter could not resolve " + className, new NullLiteral((SourceInfo)pair.getFirst())));
            }
        }
        _log.log("\nDUMPING SYMBOLTABLE AFTER PASS 1\n\n" + symbolTable + "\n");
        Enumeration<SymbolData> keys = _newSDs.keys();
        while (keys.hasMoreElements()) {
            SymbolData key = keys.nextElement();
            LanguageLevelVisitor languageLevelVisitor = _newSDs.get(key);
            if (languageLevelVisitor == null) continue;
            languageLevelVisitor.createConstructor(key);
        }
        languageLevelVisitorErrors.addAll(LanguageLevelVisitor.errors);
        if (languageLevelVisitorErrors.size() > 0) {
            this._visitorErrors.addAll(languageLevelVisitorErrors);
        } else {
            for (Triple triple : visited) {
                llv = (LanguageLevelVisitor)triple.getFirst();
                sf = (SourceFile)triple.getSecond();
                f = (File)triple.getThird();
                if (LanguageLevelConverter.isAdvancedFile(f)) {
                    toAugment.addLast(triple);
                    continue;
                }
                if (!LanguageLevelConverter.isLanguageLevelFile(f)) continue;
                if (symbolTable.get("java.lang.Integer") == null) {
                    llv.getSymbolData("java.lang.Integer", SourceInfo.NO_INFO);
                }
                if (symbolTable.get("java.lang.Double") == null) {
                    llv.getSymbolData("java.lang.Double", SourceInfo.NO_INFO);
                }
                if (symbolTable.get("java.lang.Boolean") == null) {
                    llv.getSymbolData("java.lang.Boolean", SourceInfo.NO_INFO);
                }
                if (symbolTable.get("java.lang.Long") == null) {
                    llv.getSymbolData("java.lang.Long", SourceInfo.NO_INFO);
                }
                if (symbolTable.get("java.lang.Byte") == null) {
                    llv.getSymbolData("java.lang.Byte", SourceInfo.NO_INFO);
                }
                if (symbolTable.get("java.lang.Short") == null) {
                    llv.getSymbolData("java.lang.Short", SourceInfo.NO_INFO);
                }
                if (symbolTable.get("java.lang.Float") == null) {
                    llv.getSymbolData("java.lang.Float", SourceInfo.NO_INFO);
                }
                if (symbolTable.get("java.lang.Character") == null) {
                    llv.getSymbolData("java.lang.Character", SourceInfo.NO_INFO);
                }
                TypeChecker btc = new TypeChecker(llv._file, llv._package, LanguageLevelVisitor.errors, symbolTable, llv._importedFiles, llv._importedPackages);
                sf.visit(btc);
                toAugment.addLast(triple);
                if (TypeChecker.errors.size() <= 0) continue;
                this._visitorErrors.addAll(TypeChecker.errors);
            }
        }
        if (this._parseExceptions.size() > 0 || this._visitorErrors.size() > 0) {
            return new Pair<LinkedList<JExprParseException>, LinkedList<Pair<String, JExpressionIF>>>(this._parseExceptions, this._visitorErrors);
        }
        for (Triple triple : toAugment) {
            try {
                llv = (LanguageLevelVisitor)triple.getFirst();
                sf = (SourceFile)triple.getSecond();
                f = (File)triple.getThird();
                File augmentedFile = LanguageLevelConverter.getJavaForLLFile(f);
                if (LanguageLevelConverter.isAdvancedFile(f)) {
                    Utilities.copyFile(f, augmentedFile);
                    continue;
                }
                BufferedReader tempBr = new BufferedReader(new FileReader(f));
                String firstLine = tempBr.readLine();
                tempBr.close();
                if (firstLine == null || !LanguageLevelConverter.isLanguageLevelFile(f) || triple == null) continue;
                BufferedReader br = new BufferedReader(new FileReader(f), 8192);
                StringWriter sw = new StringWriter();
                BufferedWriter bw = new BufferedWriter(sw);
                Augmentor a = new Augmentor(false, br, bw, llv);
                sf.visit(a);
                br.close();
                bw.close();
                PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(augmentedFile)));
                SortedMap<Integer, Integer> lineNumberMap = a.getLineNumberMap();
                pw.println("// Language Level Converter line number map: dj*->java. Entries: " + lineNumberMap.size());
                int numLines = (int)Math.ceil((double)lineNumberMap.size() / 8.0);
                int mapCount = 0;
                for (Map.Entry<Integer, Integer> e : lineNumberMap.entrySet()) {
                    if (mapCount % 8 == 0) {
                        pw.print("//");
                    }
                    pw.printf(" %5d->%-5d", e.getKey(), e.getValue() + numLines + 1);
                    if (mapCount % 8 == 7) {
                        pw.println();
                    }
                    ++mapCount;
                }
                if (mapCount % 8 != 0) {
                    pw.println();
                }
                String augmented = sw.toString();
                pw.write(augmented, 0, augmented.length());
                pw.close();
            }
            catch (Augmentor.Exception ae) {
                this._addVisitorError(new Pair<String, JExpressionIF>(ae.getMessage(), new NullLiteral(SourceInfo.NO_INFO)));
            }
            catch (IOException ioe) {
                this._addVisitorError(new Pair<String, JExpressionIF>(ioe.getMessage(), new NullLiteral(SourceInfo.NO_INFO)));
            }
        }
        return new Pair<LinkedList<JExprParseException>, LinkedList<Pair<String, JExpressionIF>>>(this._parseExceptions, this._visitorErrors);
    }

    public static boolean isElementaryFile(File f) {
        return f.getPath().endsWith(".dj0");
    }

    public static boolean isIntermediateFile(File f) {
        return f.getPath().endsWith(".dj1");
    }

    public static boolean isAdvancedFile(File f) {
        return f.getPath().endsWith(".dj2");
    }

    public static boolean isFunctionalJavaFile(File f) {
        return f.getPath().endsWith(".dj");
    }

    public static boolean isFullJavaFile(File f) {
        return f.getPath().endsWith(".java");
    }

    private static boolean isLanguageLevelFile(File f) {
        return LanguageLevelConverter.isElementaryFile(f) || LanguageLevelConverter.isIntermediateFile(f) || LanguageLevelConverter.isFunctionalJavaFile(f);
    }

    private static boolean isJavaFile(File f) {
        return LanguageLevelConverter.isLanguageLevelFile(f) || LanguageLevelConverter.isAdvancedFile(f) || LanguageLevelConverter.isFullJavaFile(f);
    }

    private static File getJavaForLLFile(File f) {
        String augmentedFilePath = f.getAbsolutePath();
        int dotPos = augmentedFilePath.lastIndexOf(46);
        augmentedFilePath = augmentedFilePath.substring(0, dotPos);
        return new File(augmentedFilePath + ".java");
    }

    public static boolean versionSupportsAutoboxing(JavaVersion version) {
        return version.supports(JavaVersion.JAVA_5);
    }

    public static boolean versionSupportsGenerics(JavaVersion version) {
        return version.supports(JavaVersion.JAVA_5);
    }

    public static boolean versionSupportsForEach(JavaVersion version) {
        return version.supports(JavaVersion.JAVA_5);
    }

    public static boolean versionIs15(JavaVersion version) {
        return version.supports(JavaVersion.JAVA_5);
    }

    public static void main(String[] args) {
        LanguageLevelConverter llc = new LanguageLevelConverter();
        if (args.length == 0) {
            System.out.println("Java Language Level Converter");
            System.out.println("Please pass file names (*.dj, *.dj0, *.dj1, *.dj2) as arguments.");
            System.out.println("Note: The converter will use Java's classpath to resolve classes.");
            System.out.println("      If classes are not found, use java -cp <classpath> to set the classpath.");
            return;
        }
        File[] files = new File[args.length];
        for (int i = 0; i < args.length; ++i) {
            files[i] = new File(args[i]);
        }
        Pair<LinkedList<JExprParseException>, LinkedList<Pair<String, JExpressionIF>>> result = llc.convert(files, new Options(JavaVersion.JAVA_5, IOUtil.parsePath(System.getProperty("java.class.path", ""))));
        System.out.println(result.getFirst().size() + result.getSecond().size() + " errors.");
        for (JExprParseException jExprParseException : result.getFirst()) {
            System.out.println(jExprParseException);
        }
        for (Pair pair : result.getSecond()) {
            System.out.println((String)pair.getFirst() + " " + ((JExpressionIF)pair.getSecond()).getSourceInfo());
        }
    }
}

