/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.cache;

import edu.rice.cs.drjava.model.FileMovedException;
import edu.rice.cs.drjava.model.OpenDefinitionsDocument;
import edu.rice.cs.drjava.model.cache.DCacheAdapter;
import edu.rice.cs.drjava.model.cache.DDReconstructor;
import edu.rice.cs.drjava.model.definitions.DefinitionsDocument;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.iter.SnapshotIterable;
import edu.rice.cs.util.Log;
import edu.rice.cs.util.UnexpectedException;
import edu.rice.cs.util.swing.Utilities;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;

public class DocumentCache {
    private static final Log _log = new Log("DocumentCache.txt", false);
    private static final int INIT_CACHE_SIZE = 32;
    private int CACHE_SIZE;
    private LinkedHashSet<DocManager> _residentQueue;
    private Object _cacheLock = new Object();
    private static final int IN_QUEUE = 0;
    private static final int UNTITLED = 1;
    private static final int NOT_IN_QUEUE = 2;
    private static final int UNMANAGED = 3;
    private LinkedList<RegistrationListener> _regListeners = new LinkedList();

    public DocumentCache(int size) {
        this.CACHE_SIZE = size;
        this._residentQueue = new LinkedHashSet();
    }

    public DocumentCache() {
        this(32);
    }

    public DCacheAdapter register(OpenDefinitionsDocument odd, DDReconstructor rec) {
        DocManager mgr = new DocManager(rec, odd.isUntitled());
        this.notifyRegistrationListeners(odd, mgr);
        return mgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCacheSize(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Cannot set the cache size to zero or less.");
        }
        Object object = this._cacheLock;
        synchronized (object) {
            this.CACHE_SIZE = size;
            int diff = this._residentQueue.size() - this.CACHE_SIZE;
            if (diff > 0) {
                SnapshotIterable<DocManager> toRemove = IterUtil.snapshot(IterUtil.truncate(this._residentQueue, diff));
                for (DocManager dm : toRemove) {
                    this._residentQueue.remove(dm);
                    dm.kickOut();
                }
            }
        }
    }

    public int getCacheSize() {
        return this.CACHE_SIZE;
    }

    public int getNumInCache() {
        return this._residentQueue.size();
    }

    public String toString() {
        return this._residentQueue.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRegistrationListener(RegistrationListener list) {
        LinkedList<RegistrationListener> linkedList = this._regListeners;
        synchronized (linkedList) {
            this._regListeners.add(list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRegistrationListener(RegistrationListener list) {
        LinkedList<RegistrationListener> linkedList = this._regListeners;
        synchronized (linkedList) {
            this._regListeners.remove(list);
        }
    }

    public void clearRegistrationListeners() {
        this._regListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyRegistrationListeners(final OpenDefinitionsDocument odd, final DocManager man) {
        LinkedList<RegistrationListener> linkedList = this._regListeners;
        synchronized (linkedList) {
            if (this._regListeners.isEmpty()) {
                return;
            }
            Utilities.invokeAndWait(new Runnable(){

                public void run() {
                    for (RegistrationListener list : DocumentCache.this._regListeners) {
                        list.registered(odd, man);
                    }
                }
            });
        }
    }

    public static interface RegistrationListener {
        public void registered(OpenDefinitionsDocument var1, DCacheAdapter var2);
    }

    private class DocManager
    implements DCacheAdapter {
        private final DDReconstructor _rec;
        private volatile int _stat;
        private volatile DefinitionsDocument _doc;

        public DocManager(DDReconstructor rec, boolean isUntitled) {
            this._rec = rec;
            this._stat = isUntitled ? 1 : 2;
            this._doc = null;
        }

        public void addDocumentListener(DocumentListener l) {
            this._rec.addDocumentListener(l);
        }

        private DefinitionsDocument makeDocument() {
            try {
                this._doc = this._rec.make();
                assert (this._doc != null);
            }
            catch (Exception e) {
                throw new UnexpectedException(e);
            }
            if (this._stat == 2) {
                this.add();
            }
            return this._doc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DefinitionsDocument getDocument() throws IOException, FileMovedException {
            DefinitionsDocument doc = this._doc;
            if (doc != null) {
                return doc;
            }
            Object object = DocumentCache.this._cacheLock;
            synchronized (object) {
                if (this._doc != null) {
                    return this._doc;
                }
                return this.makeDocument();
            }
        }

        public int getLength() {
            DefinitionsDocument doc = this._doc;
            if (doc == null) {
                return this._rec.getText().length();
            }
            return doc.getLength();
        }

        public String getText() {
            DefinitionsDocument doc = this._doc;
            if (doc == null) {
                return this._rec.getText();
            }
            return doc.getText();
        }

        public String getText(int offset, int len) throws BadLocationException {
            DefinitionsDocument doc = this._doc;
            if (doc == null) {
                try {
                    return this._rec.getText().substring(offset, offset + len);
                }
                catch (IndexOutOfBoundsException e) {
                    throw new BadLocationException(e.getMessage(), offset);
                }
            }
            return doc.getText(offset, len);
        }

        public boolean isReady() {
            return this._doc != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            Object object = DocumentCache.this._cacheLock;
            synchronized (object) {
                DocumentCache.this._residentQueue.remove(this);
                this.closingKickOut();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void documentModified() {
            Object object = DocumentCache.this._cacheLock;
            synchronized (object) {
                DocumentCache.this._residentQueue.remove(this);
                this._stat = 3;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void documentReset() {
            Object object = DocumentCache.this._cacheLock;
            synchronized (object) {
                if (this._stat == 3) {
                    this.add();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void documentSaved() {
            Object object = DocumentCache.this._cacheLock;
            synchronized (object) {
                if (this.isUnmanagedOrUntitled()) {
                    this.add();
                }
            }
        }

        private void add() {
            if (!DocumentCache.this._residentQueue.contains(this)) {
                DocumentCache.this._residentQueue.add(this);
                this._stat = 0;
            }
            if (DocumentCache.this._residentQueue.size() > DocumentCache.this.CACHE_SIZE) {
                ((DocManager)IterUtil.first(DocumentCache.this._residentQueue)).remove();
            }
        }

        private void remove() {
            DocumentCache.this._residentQueue.remove(this);
            this.kickOut();
        }

        private boolean isUnmanagedOrUntitled() {
            return (this._stat & 1) != 0;
        }

        void kickOut() {
            this.kickOut(false);
        }

        void closingKickOut() {
            this.kickOut(true);
        }

        private void kickOut(boolean isClosing) {
            if (!isClosing) {
                this._rec.saveDocInfo(this._doc);
            }
            if (this._doc != null) {
                this._doc.close();
                this._doc = null;
            }
            this._stat = 2;
        }

        public String toString() {
            return "DocManager for " + this._rec.toString() + "[stat = " + this._stat + "]";
        }
    }
}

