/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.cunit.util;

import edu.rice.cs.cunit.instrumentors.threadCheck.AAddThreadCheckStrategy;
import edu.rice.cs.cunit.threadCheck.ThreadCheckException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLConfig {
    public static final String NL = System.getProperty("line.separator");
    private Document _document;

    public XMLConfig() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            this._document = builder.newDocument();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
    }

    public XMLConfig(InputStream is) {
        this.init(new InputSource(is));
    }

    public XMLConfig(Reader r) {
        this.init(new InputSource(r));
    }

    private void init(InputSource is) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
            this._document = builder.parse(is);
        }
        catch (Exception e) {
            throw new XMLConfigException("Error in ctor", e);
        }
        this._document.normalize();
    }

    public XMLConfig(File f) {
        try {
            this.init(new InputSource(new FileInputStream(f)));
        }
        catch (FileNotFoundException e) {
            throw new XMLConfigException("Error in ctor", e);
        }
    }

    public XMLConfig(String filename) {
        try {
            this.init(new InputSource(new FileInputStream(filename)));
        }
        catch (FileNotFoundException e) {
            throw new XMLConfigException("Error in ctor", e);
        }
    }

    public void save(OutputStream os) {
        DOMSource source = new DOMSource(this._document);
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            tf.setAttribute("indent-number", new Integer(2));
            Transformer t = tf.newTransformer();
            t.setOutputProperty("indent", "yes");
            t.transform(source, new StreamResult(new OutputStreamWriter(os, "utf-8")));
        }
        catch (TransformerException e) {
            throw new XMLConfigException("Error in save", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new XMLConfigException("Error in save", e);
        }
    }

    public void save(File f) {
        try {
            this.save(new FileOutputStream(f));
        }
        catch (FileNotFoundException e) {
            throw new XMLConfigException("Error in save", e);
        }
    }

    public void save(String filename) {
        this.save(new File(filename));
    }

    public String get(String path) {
        List<String> r = this.getMultiple(path);
        if (r.size() != 1) {
            throw new XMLConfigException("Number of results != 1");
        }
        return r.get(0);
    }

    public List<String> getMultiple(String path) {
        return this.getMultiple(path, this._document);
    }

    public List<String> getMultiple(String path, Node root) {
        List<Node> accum = this.getNodes(path, root);
        LinkedList<String> strings = new LinkedList<String>();
        for (Node n : accum) {
            if (n instanceof Attr) {
                strings.add(n.getNodeValue());
                continue;
            }
            String acc = "";
            for (Node child = n.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child.getNodeName().equals("#text")) {
                    acc = acc + " " + child.getNodeValue();
                    continue;
                }
                if (child.getNodeName().equals("#comment")) continue;
                throw new XMLConfigException("Node " + n.getNodeName() + " contained node " + child.getNodeName() + ", but should only contain #text and #comment.");
            }
            strings.add(acc.trim());
        }
        return strings;
    }

    public List<Node> getNodes(String path) {
        return this.getNodes(path, this._document);
    }

    public List<Node> getNodes(String path, Node root) {
        LinkedList<Node> accum = new LinkedList<Node>();
        this.getMultipleHelper(path, root, accum, false);
        return accum;
    }

    private void getMultipleHelper(String path, Node n, List<Node> accum, boolean dotRead) {
        int slashPos;
        boolean initialDot;
        int dotPos = path.indexOf(46);
        boolean bl = initialDot = dotPos == 0;
        if (path.length() > 0 && dotPos == -1 && !path.endsWith("/")) {
            path = path + "/";
        }
        if (((slashPos = path.indexOf(47)) > -1 || dotPos > -1) && !dotRead || initialDot) {
            Node child;
            String nodeName;
            if (slashPos > -1 && (dotPos == -1 || slashPos < dotPos)) {
                nodeName = path.substring(0, slashPos);
                path = path.substring(slashPos + 1);
            } else {
                if (slashPos > -1) {
                    throw new XMLConfigException("An attribute cannot have subparts (foo.bar.fum and foo.bar/fum not allowed)");
                }
                if (!initialDot) {
                    nodeName = path.substring(0, dotPos);
                    path = path.substring(dotPos + 1);
                    dotRead = true;
                } else {
                    String nodeName2;
                    path = nodeName2 = path.substring(1);
                    this.getMultipleAddAttributesHelper(path, n, accum);
                    return;
                }
            }
            if (nodeName.equals("*")) {
                for (child = n.getFirstChild(); child != null; child = child.getNextSibling()) {
                    if (child.getNodeName().equals("#text") || child.getNodeName().equals("#comment")) continue;
                    if (dotRead) {
                        this.getMultipleAddAttributesHelper(path, child, accum);
                        continue;
                    }
                    this.getMultipleHelper(path, child, accum, false);
                }
                return;
            }
            while (child != null) {
                if (child.getNodeName().equals(nodeName)) {
                    if (dotRead) {
                        this.getMultipleAddAttributesHelper(path, child, accum);
                    } else {
                        this.getMultipleHelper(path, child, accum, false);
                    }
                }
                child = child.getNextSibling();
            }
            return;
        }
        accum.add(n);
    }

    private void getMultipleAddAttributesHelper(String path, Node n, List<Node> accum) {
        if (path.indexOf(46) > -1 || path.indexOf(47) > -1) {
            throw new XMLConfigException("An attribute cannot have subparts (foo.bar.fum and foo.bar/fum not allowed)");
        }
        NamedNodeMap attrMap = n.getAttributes();
        if (path.equals("*")) {
            for (int i = 0; i < attrMap.getLength(); ++i) {
                accum.add(attrMap.item(i));
            }
        } else {
            Node attr = attrMap.getNamedItem(path);
            accum.add(attr);
        }
    }

    public String get(String path, String defaultVal) {
        try {
            return this.get(path);
        }
        catch (XMLConfigException e) {
            return defaultVal;
        }
    }

    public Node set(String path, String value) {
        return this.set(path, value, this._document, true);
    }

    public Node set(String path, String value, boolean overwrite) {
        return this.set(path, value, this._document, overwrite);
    }

    public Node set(String path, String value, Node n, boolean overwrite) {
        int dotPos = path.lastIndexOf(46);
        Node node = dotPos == 0 ? n : this.createNode(path, n, overwrite);
        if (dotPos >= 0) {
            Element e = (Element)node;
            e.setAttribute(path.substring(dotPos + 1), value);
        } else {
            node.appendChild(this._document.createTextNode(value));
        }
        return node;
    }

    public Node createNode(String path) {
        return this.createNode(path, this._document, true);
    }

    public Node createNode(String path, Node n) {
        return this.createNode(path, n, true);
    }

    public Node createNode(String path, Node n, boolean overwrite) {
        String nodeName;
        if (n == null) {
            n = this._document;
        }
        while (path.indexOf(47) > -1) {
            Node child = null;
            String nodeName2 = path.substring(0, path.indexOf(47));
            path = path.substring(path.indexOf(47) + 1);
            for (child = n.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (!child.getNodeName().equals(nodeName2)) continue;
                n = child;
                break;
            }
            if (child != null) continue;
            child = this._document.createElement(nodeName2);
            n.appendChild(child);
            n = child;
        }
        if (path.indexOf(46) > -1) {
            nodeName = path.substring(0, path.indexOf(46));
        } else {
            if (path.length() == 0) {
                throw new XMLConfigException("Cannot set node with empty name");
            }
            nodeName = path;
        }
        Node child = null;
        if (nodeName.length() > 0) {
            if (overwrite) {
                for (child = n.getFirstChild(); child != null; child = child.getNextSibling()) {
                    if (!child.getNodeName().equals(nodeName)) continue;
                    n = child;
                    break;
                }
                if (child == null) {
                    child = this._document.createElement(nodeName);
                    n.appendChild(child);
                    n = child;
                }
            } else {
                child = this._document.createElement(nodeName);
                n.appendChild(child);
                n = child;
            }
        }
        if (path.indexOf(46) > -1) {
            if (!(n instanceof Element)) {
                throw new XMLConfigException("Node " + n.getNodeName() + " should be an element so it can contain attributes");
            }
            return n;
        }
        if (overwrite) {
            child = n.getFirstChild();
            while (child != null) {
                Node temp = child.getNextSibling();
                n.removeChild(child);
                child = temp;
            }
            return n;
        }
        return child;
    }

    public String toString() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        this.save(os);
        return os.toString();
    }

    public static String getNodePath(Node n) {
        if (n == null) {
            return "";
        }
        String path = "";
        while (n.getParentNode() != null) {
            path = n.getNodeName() + "/" + path;
            n = n.getParentNode();
        }
        return path.substring(0, path.length() - 1);
    }

    public static class XMLConfigTest
    extends TestCase {
        public void testNodes() throws Exception {
            XMLConfig xc = new XMLConfig(new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?><foo a=\"foo.a\">\n  <bar>abc</bar>\n  <fum fee=\"xyz\">def</fum>\n</foo>"));
            XMLConfigTest.assertEquals("abc", xc.get("foo/bar"));
            XMLConfigTest.assertEquals("def", xc.get("foo/fum"));
        }

        public void testAttrs() throws Exception {
            XMLConfig xc = new XMLConfig(new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?><foo a=\"foo.a\">\n  <bar>abc</bar>\n  <fum fee=\"xyz\">def</fum>\n</foo>"));
            XMLConfigTest.assertEquals("foo.a", xc.get("foo.a"));
            XMLConfigTest.assertEquals("xyz", xc.get("foo/fum.fee"));
        }

        public void testExceptions() throws Exception {
            XMLConfig xc = new XMLConfig(new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?><foo a=\"foo.a\">\n  <bar>abc</bar>\n  <fum fee=\"xyz\">def</fum>\n</foo>"));
            try {
                xc.get("");
                XMLConfigTest.fail("Should throw 'no node' exception");
            }
            catch (RuntimeException e) {
                // empty catch block
            }
            try {
                xc.get("xyz");
                XMLConfigTest.fail("Should throw 'no node' exception");
            }
            catch (RuntimeException e) {
                // empty catch block
            }
            try {
                xc.get("foo.xyz");
                XMLConfigTest.fail("Should throw 'no node' exception");
            }
            catch (RuntimeException e) {
                // empty catch block
            }
            try {
                xc.get("foo.b");
                XMLConfigTest.fail("Should throw 'no attribute' exception");
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }

        private String remove16XML(String s) {
            if (System.getProperty("java.version").startsWith("1.5") || System.getProperty("java.version").startsWith("1.4")) {
                int pos1 = s.indexOf(" standalone=");
                int pos2 = s.indexOf("?>", pos1);
                return s.substring(0, pos1) + s.substring(pos2);
            }
            return s;
        }

        public void testSave() throws Exception {
            XMLConfig xc = new XMLConfig(new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?><foo a=\"foo.a\">\n  <bar>abc</bar>\n  <fum fee=\"xyz\">def</fum>\n</foo>"));
            XMLConfigTest.assertEquals(this.remove16XML("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>" + NL + "<foo a=\"foo.a\">" + NL + "  <bar>abc</bar>" + NL + "  <fum fee=\"xyz\">def</fum>" + NL + "</foo>" + NL), xc.toString());
        }

        public void testSetNodeFromEmpty() throws Exception {
            XMLConfig xc = new XMLConfig();
            xc.set("foo/bar", "abc");
            XMLConfigTest.assertEquals(this.remove16XML("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>" + NL + "<foo>" + NL + "  <bar>abc</bar>" + NL + "</foo>" + NL), xc.toString());
            XMLConfigTest.assertEquals("abc", xc.get("foo/bar"));
            xc.set("foo/fum", "def");
            XMLConfigTest.assertEquals(this.remove16XML("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>" + NL + "<foo>" + NL + "  <bar>abc</bar>" + NL + "  <fum>def</fum>" + NL + "</foo>" + NL), xc.toString());
            XMLConfigTest.assertEquals("def", xc.get("foo/fum"));
        }

        public void testSetNodeOverwrite() throws Exception {
            XMLConfig xc = new XMLConfig();
            xc.set("foo/bar", "abc");
            XMLConfigTest.assertEquals(this.remove16XML("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>" + NL + "<foo>" + NL + "  <bar>abc</bar>" + NL + "</foo>" + NL), xc.toString());
            XMLConfigTest.assertEquals("abc", xc.get("foo/bar"));
            xc.set("foo/bar", "def");
            XMLConfigTest.assertEquals(this.remove16XML("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>" + NL + "<foo>" + NL + "  <bar>def</bar>" + NL + "</foo>" + NL), xc.toString());
            XMLConfigTest.assertEquals("def", xc.get("foo/bar"));
            xc.set("foo", "xyz");
            XMLConfigTest.assertEquals(this.remove16XML("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>" + NL + "<foo>xyz</foo>" + NL), xc.toString());
            XMLConfigTest.assertEquals("xyz", xc.get("foo"));
        }

        public void testSetAttrFromEmpty() throws Exception {
            XMLConfig xc = new XMLConfig();
            xc.set("foo.bar", "abc");
            XMLConfigTest.assertEquals(this.remove16XML("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>" + NL + "<foo bar=\"abc\"/>" + NL), xc.toString());
            XMLConfigTest.assertEquals("abc", xc.get("foo.bar"));
            xc.set("foo/fum.fee", "def");
            XMLConfigTest.assertEquals(this.remove16XML("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>" + NL + "<foo bar=\"abc\">" + NL + "  <fum fee=\"def\"/>" + NL + "</foo>" + NL), xc.toString());
            XMLConfigTest.assertEquals("def", xc.get("foo/fum.fee"));
        }

        public void testSetAttrOverwrite() throws Exception {
            XMLConfig xc = new XMLConfig();
            xc.set("foo.bar", "abc");
            XMLConfigTest.assertEquals(this.remove16XML("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>" + NL + "<foo bar=\"abc\"/>" + NL), xc.toString());
            XMLConfigTest.assertEquals("abc", xc.get("foo.bar"));
            xc.set("foo.bar", "def");
            XMLConfigTest.assertEquals(this.remove16XML("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>" + NL + "<foo bar=\"def\"/>" + NL), xc.toString());
            XMLConfigTest.assertEquals("def", xc.get("foo.bar"));
        }

        public void testSetNodeNoOverwrite() throws Exception {
            XMLConfig xc = new XMLConfig();
            xc.set("foo/bar", "abc", false);
            XMLConfigTest.assertEquals(this.remove16XML("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>" + NL + "<foo>" + NL + "  <bar>abc</bar>" + NL + "</foo>" + NL), xc.toString());
            XMLConfigTest.assertEquals("abc", xc.get("foo/bar"));
            xc.set("foo/bar", "def", false);
            XMLConfigTest.assertEquals(this.remove16XML("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>" + NL + "<foo>" + NL + "  <bar>abc</bar>" + NL + "  <bar>def</bar>" + NL + "</foo>" + NL), xc.toString());
            List<String> r = xc.getMultiple("foo/bar");
            XMLConfigTest.assertEquals(2, r.size());
            XMLConfigTest.assertEquals("abc", r.get(0));
            XMLConfigTest.assertEquals("def", r.get(1));
        }

        public void testSetAttrNoOverwrite() throws Exception {
            XMLConfig xc = new XMLConfig();
            xc.set("foo/bar.fee", "abc", false);
            XMLConfigTest.assertEquals(this.remove16XML("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>" + NL + "<foo>" + NL + "  <bar fee=\"abc\"/>" + NL + "</foo>" + NL), xc.toString());
            XMLConfigTest.assertEquals("abc", xc.get("foo/bar.fee"));
            xc.set("foo/bar.fee", "def", false);
            XMLConfigTest.assertEquals(this.remove16XML("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>" + NL + "<foo>" + NL + "  <bar fee=\"abc\"/>" + NL + "  <bar fee=\"def\"/>" + NL + "</foo>" + NL), xc.toString());
            List<String> r = xc.getMultiple("foo/bar.fee");
            XMLConfigTest.assertEquals(2, r.size());
            XMLConfigTest.assertEquals("abc", r.get(0));
            XMLConfigTest.assertEquals("def", r.get(1));
        }

        public void testSetFromNode() throws Exception {
            XMLConfig xc = new XMLConfig();
            Node n = xc.set("foo/bar", "abc", false);
            XMLConfigTest.assertEquals(this.remove16XML("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>" + NL + "<foo>" + NL + "  <bar>abc</bar>" + NL + "</foo>" + NL), xc.toString());
            XMLConfigTest.assertEquals("abc", xc.get("foo/bar"));
            xc.set(".fuz", "def", n, false);
            XMLConfigTest.assertEquals(this.remove16XML("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>" + NL + "<foo>" + NL + "  <bar fuz=\"def\">abc</bar>" + NL + "</foo>" + NL), xc.toString());
            XMLConfigTest.assertEquals("abc", xc.get("foo/bar"));
            n = xc.set("fum", "", n.getParentNode(), false);
            if (System.getProperty("java.version").startsWith("1.5")) {
                XMLConfigTest.assertEquals(this.remove16XML("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>" + NL + "<foo>" + NL + "  <bar fuz=\"def\">abc</bar>" + NL + "  <fum></fum>" + NL + "</foo>" + NL), xc.toString());
            } else {
                XMLConfigTest.assertEquals(this.remove16XML("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>" + NL + "<foo>" + NL + "  <bar fuz=\"def\">abc</bar>" + NL + "  <fum/>" + NL + "</foo>" + NL), xc.toString());
            }
            XMLConfigTest.assertEquals("", xc.get("foo/fum"));
            xc.set("file", "test1.txt", n, false);
            xc.set("file", "test2.txt", n, false);
            if (System.getProperty("java.version").startsWith("1.5")) {
                XMLConfigTest.assertEquals(this.remove16XML("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>" + NL + "<foo>" + NL + "  <bar fuz=\"def\">abc</bar>" + NL + "  <fum><file>test1.txt</file>" + NL + "    <file>test2.txt</file>" + NL + "  </fum>" + NL + "</foo>" + NL), xc.toString());
            } else {
                XMLConfigTest.assertEquals(this.remove16XML("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>" + NL + "<foo>" + NL + "  <bar fuz=\"def\">abc</bar>" + NL + "  <fum>" + NL + "    <file>test1.txt</file>" + NL + "    <file>test2.txt</file>" + NL + "  </fum>" + NL + "</foo>" + NL), xc.toString());
            }
            List<String> r = xc.getMultiple("foo/fum/file");
            XMLConfigTest.assertEquals(2, r.size());
            XMLConfigTest.assertEquals("test1.txt", r.get(0));
            XMLConfigTest.assertEquals("test2.txt", r.get(1));
        }

        public void testMultipleNodes() throws Exception {
            XMLConfig xc = new XMLConfig(new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><foo a=\"foo.a\">\n  <bar>abc</bar>\n  <bar>ghi</bar>\n  <fum fee=\"xyz\">def</fum>\n</foo>"));
            List<String> r = xc.getMultiple("foo/bar");
            XMLConfigTest.assertEquals(2, r.size());
            XMLConfigTest.assertEquals("abc", r.get(0));
            XMLConfigTest.assertEquals("ghi", r.get(1));
        }

        public void testMultipleNodesAttr() throws Exception {
            XMLConfig xc = new XMLConfig(new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><foo a=\"foo.a\">\n  <bar fuz=\"aaa\">abc</bar>\n  <bar fuz=\"bbb\">ghi</bar>\n  <fum fee=\"xyz\">def</fum>\n</foo>"));
            List<String> r = xc.getMultiple("foo/bar.fuz");
            XMLConfigTest.assertEquals(2, r.size());
            XMLConfigTest.assertEquals("aaa", r.get(0));
            XMLConfigTest.assertEquals("bbb", r.get(1));
        }

        public void testNodesStarEnd() throws Exception {
            XMLConfig xc = new XMLConfig(new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><foo a=\"foo.a\">\n  <bar>abc</bar>\n  <bar>ghi</bar>\n  <fum fee=\"xyz\">def</fum>\n</foo>"));
            List<String> r = xc.getMultiple("foo/*");
            XMLConfigTest.assertEquals(3, r.size());
            XMLConfigTest.assertEquals("abc", r.get(0));
            XMLConfigTest.assertEquals("ghi", r.get(1));
            XMLConfigTest.assertEquals("def", r.get(2));
        }

        public void testNodesStarMiddle() throws Exception {
            XMLConfig xc = new XMLConfig(new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><foo a=\"foo.a\">\n  <bar fee=\"xxx\" fuz=\"aaa\">abc</bar>\n  <bar fee=\"yyy\" fuz=\"bbb\">ghi</bar>\n  <fum fee=\"zzz\" fuz=\"ccc\">def</fum>\n</foo>"));
            List<String> r = xc.getMultiple("foo/*.fee");
            XMLConfigTest.assertEquals(3, r.size());
            XMLConfigTest.assertEquals("xxx", r.get(0));
            XMLConfigTest.assertEquals("yyy", r.get(1));
            XMLConfigTest.assertEquals("zzz", r.get(2));
            r = xc.getMultiple("foo/*.*");
            XMLConfigTest.assertEquals(6, r.size());
            XMLConfigTest.assertEquals("xxx", r.get(0));
            XMLConfigTest.assertEquals("aaa", r.get(1));
            XMLConfigTest.assertEquals("yyy", r.get(2));
            XMLConfigTest.assertEquals("bbb", r.get(3));
            XMLConfigTest.assertEquals("zzz", r.get(4));
            XMLConfigTest.assertEquals("ccc", r.get(5));
            xc = new XMLConfig(new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><flub>\n  <foo/>\n  <fee/>\n  <fum foz=\"abc\"/></flub>"));
            r = xc.getMultiple("flub/*");
            XMLConfigTest.assertEquals(3, r.size());
        }

        public void testAttrsStarEnd() throws Exception {
            XMLConfig xc = new XMLConfig(new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><foo a=\"foo.a\">\n  <bar>abc</bar>\n  <fum fee=\"xyz\" fuz=\"zzz\" fiz=\"aaa\">def</fum>\n</foo>"));
            List<String> r = xc.getMultiple("foo.*");
            XMLConfigTest.assertEquals(1, r.size());
            XMLConfigTest.assertEquals("foo.a", r.get(0));
            r = xc.getMultiple("foo/fum.*");
            XMLConfigTest.assertEquals(3, r.size());
            XMLConfigTest.assertEquals("xyz", r.get(0));
            XMLConfigTest.assertEquals("aaa", r.get(1));
            XMLConfigTest.assertEquals("zzz", r.get(2));
        }

        public void testNodeStarAttrsStar() throws Exception {
            XMLConfig xc = new XMLConfig(new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><foo a=\"foo.a\">\n  <bar flubb=\"mno\">abc</bar>\n  <fum fee=\"xyz\" fuz=\"zzz\" fiz=\"aaa\">def</fum>\n</foo>"));
            List<String> r = xc.getMultiple("*.*");
            XMLConfigTest.assertEquals(1, r.size());
            XMLConfigTest.assertEquals("foo.a", r.get(0));
            r = xc.getMultiple("foo/*.*");
            XMLConfigTest.assertEquals(4, r.size());
            XMLConfigTest.assertEquals("mno", r.get(0));
            XMLConfigTest.assertEquals("xyz", r.get(1));
            XMLConfigTest.assertEquals("aaa", r.get(2));
            XMLConfigTest.assertEquals("zzz", r.get(3));
        }

        public void testGetNodePath1() throws Exception {
            XMLConfig xc = new XMLConfig(new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><concutest>\n  <threadcheck:def>\n    <invariant>\n      <name type=\"only\" value=\"childclass1\"/>\n    </invariant>\n    <class name=\"sample.threadCheck.ThreadCheckSample4\"/>\n  </threadcheck:def>\n  <threadcheck:def>\n    <invariant>\n      <name type=\"only\" value=\"childclass-method1\"/>\n    </invariant>\n    <method name=\"sample.threadCheck.ThreadCheckSample4\" sig=\"run()V\"/>\n    <method name=\"sample.threadCheck.ThreadCheckSample4\" sig=\"run2()V\"/>\n  </threadcheck:def>\n</concutest>"));
            XMLConfigTest.assertEquals("Path of null is wrong", "", XMLConfig.getNodePath(null));
            List<Node> roots = xc.getNodes("concutest");
            Assert.assertEquals(1, roots.size());
            XMLConfigTest.assertEquals("Path of " + roots.get(0).getNodeName() + " is wrong", "concutest", XMLConfig.getNodePath(roots.get(0)));
            List<Node> defs = xc.getNodes("concutest/threadcheck:def");
            Assert.assertEquals(2, defs.size());
            for (Node def : defs) {
                XMLConfigTest.assertEquals("Path of " + def.getNodeName() + " is wrong", "concutest/threadcheck:def", XMLConfig.getNodePath(def));
                List<Node> invs = xc.getNodes("invariant", def);
                Assert.assertEquals(1, invs.size());
                Node inv = invs.get(0);
                XMLConfigTest.assertEquals("Path of " + inv.getNodeName() + " is wrong", "concutest/threadcheck:def/invariant", XMLConfig.getNodePath(inv));
                List<Node> annots = xc.getNodes("*", inv);
                Assert.assertEquals(1, annots.size());
                XMLConfigTest.assertEquals("Path of " + annots.get(0).getNodeName() + " is wrong", "concutest/threadcheck:def/invariant/name", XMLConfig.getNodePath(annots.get(0)));
                List<Node> classes = xc.getNodes("class", def);
                List<Node> methods = xc.getNodes("method", def);
                Assert.assertTrue("There must be at least one class or method per definition", classes.size() + methods.size() > 0);
                List<Node> all = xc.getNodes("*", def);
                Assert.assertEquals(0, all.size() - invs.size() - classes.size() - methods.size());
                for (Node target : classes) {
                    XMLConfigTest.assertEquals("Path of " + target.getNodeName() + " is wrong", "concutest/threadcheck:def/class", XMLConfig.getNodePath(target));
                }
                for (Node target : methods) {
                    XMLConfigTest.assertEquals("Path of " + target.getNodeName() + " is wrong", "concutest/threadcheck:def/method", XMLConfig.getNodePath(target));
                }
            }
        }

        public void testXMLConcDef() throws Exception {
            XMLConfig xc = new XMLConfig(new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><concutest>\n  <threadcheck:def>\n    <invariant>\n      <name type=\"only\" value=\"childclass1\"/>\n    </invariant>\n    <class name=\"sample.threadCheck.ThreadCheckSample4\"/>\n  </threadcheck:def>\n  <threadcheck:def>\n    <invariant>\n      <name type=\"only\" value=\"childclass-method1\"/>\n    </invariant>\n    <method name=\"sample.threadCheck.ThreadCheckSample4\" sig=\"run()V\"/>\n    <method name=\"sample.threadCheck.ThreadCheckSample4\" sig=\"run2()V\"/>\n    <class name=\"sample.threadCheck.ThreadCheckSample4\"/>\n  </threadcheck:def>\n</concutest>"));
            List<Node> defs = xc.getNodes("concutest/threadcheck:def");
            Assert.assertEquals(2, defs.size());
            Set<ThreadCheckException> tces = AAddThreadCheckStrategy.checkXMLConcDef(xc);
            XMLConfigTest.assertEquals(0, tces.size());
        }

        public void testXMLConcDefWrong1() throws Exception {
            XMLConfig xc = new XMLConfig(new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><concutest>\n  <threadcheck:def>\n    <invariant>\n      <name type=\"only\" value=\"childclass1\"/>\n      <name type=\"only\" value=\"childclass2\"/>\n    </invariant>\n    <class name=\"sample.threadCheck.ThreadCheckSample4\"/>\n  </threadcheck:def>\n  <threadcheck:def>\n    <invariant>\n      <name type=\"only\" value=\"childclass-method1\"/>\n    </invariant>\n    <method name=\"sample.threadCheck.ThreadCheckSample4\" sig=\"run()V\"/>\n    <method name=\"sample.threadCheck.ThreadCheckSample4\" sig=\"run2()V\"/>\n  </threadcheck:def>\n</concutest>"));
            List<Node> defs = xc.getNodes("concutest/threadcheck:def");
            Assert.assertEquals(2, defs.size());
            Set<ThreadCheckException> tces = AAddThreadCheckStrategy.checkXMLConcDef(xc);
            XMLConfigTest.assertEquals(1, tces.size());
            XMLConfigTest.assertTrue("Wrong message", tces.contains(new ThreadCheckException("There must be exactly one annotation per invariant, found 2 (path: concutest/threadcheck:def/invariant/name)")));
        }

        public void testXMLConcDefWrong2() throws Exception {
            XMLConfig xc = new XMLConfig(new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><concutest>\n  <threadcheck:def>\n    <invariant>\n      <name type=\"only\" value=\"childclass1\"/>\n    </invariant>\n    <invariant>\n      <name type=\"only\" value=\"childclass1\"/>\n    </invariant>\n    <class name=\"sample.threadCheck.ThreadCheckSample4\"/>\n  </threadcheck:def>\n  <threadcheck:def>\n    <invariant>\n      <name type=\"only\" value=\"childclass-method1\"/>\n    </invariant>\n    <method name=\"sample.threadCheck.ThreadCheckSample4\" sig=\"run()V\"/>\n    <method name=\"sample.threadCheck.ThreadCheckSample4\" sig=\"run2()V\"/>\n  </threadcheck:def>\n</concutest>"));
            List<Node> defs = xc.getNodes("concutest/threadcheck:def");
            Assert.assertEquals(2, defs.size());
            Set<ThreadCheckException> tces = AAddThreadCheckStrategy.checkXMLConcDef(xc);
            XMLConfigTest.assertEquals(1, tces.size());
            XMLConfigTest.assertTrue("Wrong message", tces.contains(new ThreadCheckException("There must be exactly one invariant per definition, found 2 (path: concutest/threadcheck:def/invariant)")));
        }

        public void testXMLConcDefWrong3() throws Exception {
            XMLConfig xc = new XMLConfig(new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><concutest>\n  <threadcheck:def>\n    <class name=\"sample.threadCheck.ThreadCheckSample4\"/>\n  </threadcheck:def>\n  <threadcheck:def>\n    <invariant>\n      <name type=\"only\" value=\"childclass-method1\"/>\n    </invariant>\n    <method name=\"sample.threadCheck.ThreadCheckSample4\" sig=\"run()V\"/>\n    <method name=\"sample.threadCheck.ThreadCheckSample4\" sig=\"run2()V\"/>\n  </threadcheck:def>\n</concutest>"));
            List<Node> defs = xc.getNodes("concutest/threadcheck:def");
            Assert.assertEquals(2, defs.size());
            Set<ThreadCheckException> tces = AAddThreadCheckStrategy.checkXMLConcDef(xc);
            XMLConfigTest.assertEquals(1, tces.size());
            XMLConfigTest.assertTrue("Wrong message", tces.contains(new ThreadCheckException("There must be exactly one invariant per definition, found 0 (path: concutest/threadcheck:def/invariant)")));
        }

        public void testXMLConcDefWrong4() throws Exception {
            XMLConfig xc = new XMLConfig(new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><concutest>\n  <threadcheck:def>\n    <invariant>\n      <name type=\"only\" value=\"childclass2\"/>\n    </invariant>\n  </threadcheck:def>\n  <threadcheck:def>\n    <invariant>\n      <name type=\"only\" value=\"childclass-method1\"/>\n    </invariant>\n    <method name=\"sample.threadCheck.ThreadCheckSample4\" sig=\"run()V\"/>\n    <method name=\"sample.threadCheck.ThreadCheckSample4\" sig=\"run2()V\"/>\n  </threadcheck:def>\n</concutest>"));
            List<Node> defs = xc.getNodes("concutest/threadcheck:def");
            Assert.assertEquals(2, defs.size());
            Set<ThreadCheckException> tces = AAddThreadCheckStrategy.checkXMLConcDef(xc);
            XMLConfigTest.assertEquals(1, tces.size());
            XMLConfigTest.assertTrue("Wrong message", tces.contains(new ThreadCheckException("There must be at least one class or method per definition, found 0 <class> and 0 <method> (path: concutest/threadcheck:def/)")));
        }

        public void testXMLConcDefWrong5() throws Exception {
            XMLConfig xc = new XMLConfig(new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><concutest>\n  <threadcheck:def>\n    <invariant>\n      <name type=\"only\" value=\"childclass2\"/>\n    </invariant>\n    <class name=\"sample.threadCheck.ThreadCheckSample4\"/>\n  </threadcheck:def>\n  <threadcheck:def>\n    <invariant>\n      <name type=\"only\" value=\"childclass-method1\"/>\n    </invariant>\n  </threadcheck:def>\n</concutest>"));
            List<Node> defs = xc.getNodes("concutest/threadcheck:def");
            Assert.assertEquals(2, defs.size());
            Set<ThreadCheckException> tces = AAddThreadCheckStrategy.checkXMLConcDef(xc);
            XMLConfigTest.assertEquals(1, tces.size());
            XMLConfigTest.assertTrue("Wrong message", tces.contains(new ThreadCheckException("There must be at least one class or method per definition, found 0 <class> and 0 <method> (path: concutest/threadcheck:def/)")));
        }

        public void testXMLConcDefWrong6() throws Exception {
            XMLConfig xc = new XMLConfig(new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><concutest>\n  <threadcheck:def>\n    <invariant>\n      <name type=\"only\" value=\"childclass2\"/>\n    </invariant>\n    <class name=\"sample.threadCheck.ThreadCheckSample4\">\n      <foo/>\n    </class>\n  </threadcheck:def>\n  <threadcheck:def>\n    <invariant>\n      <name type=\"only\" value=\"childclass-method1\"/>\n    </invariant>\n  </threadcheck:def>\n</concutest>"));
            List<Node> defs = xc.getNodes("concutest/threadcheck:def");
            Assert.assertEquals(2, defs.size());
            Set<ThreadCheckException> tces = AAddThreadCheckStrategy.checkXMLConcDef(xc);
            XMLConfigTest.assertEquals(2, tces.size());
            XMLConfigTest.assertTrue("Wrong message", tces.contains(new ThreadCheckException("A class node should have no child nodes, found 1 (path: concutest/threadcheck:def/class)")));
            XMLConfigTest.assertTrue("Wrong message", tces.contains(new ThreadCheckException("There must be at least one class or method per definition, found 0 <class> and 0 <method> (path: concutest/threadcheck:def/)")));
        }

        public void testXMLConcDefWrong7() throws Exception {
            XMLConfig xc = new XMLConfig(new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><concutest>\n  <threadcheck:def>\n    <invariant>\n      <name type=\"only\" value=\"childclass2\"/>\n    </invariant>\n    <class name=\"sample.threadCheck.ThreadCheckSample4\"/>\n  </threadcheck:def>\n  <threadcheck:def>\n    <invariant>\n      <name type=\"only\" value=\"childclass-method1\"/>\n    </invariant>\n    <method name=\"sample.threadCheck.ThreadCheckSample4\" sig=\"run2()V\">\n      <foo/>\n    </method>\n  </threadcheck:def>\n</concutest>"));
            List<Node> defs = xc.getNodes("concutest/threadcheck:def");
            Assert.assertEquals(2, defs.size());
            Set<ThreadCheckException> tces = AAddThreadCheckStrategy.checkXMLConcDef(xc);
            XMLConfigTest.assertEquals(1, tces.size());
            XMLConfigTest.assertTrue("Wrong message", tces.contains(new ThreadCheckException("A method node should have no child nodes, there were 1 (path: concutest/threadcheck:def/method)")));
        }

        public void testXMLConcDefWrong8() throws Exception {
            XMLConfig xc = new XMLConfig(new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><concutest>\n  <threadcheck:def>\n    <invariant>\n      <name type=\"only\" value=\"childclass2\"/>\n    </invariant>\n    <class name=\"sample.threadCheck.ThreadCheckSample4\"/>\n  </threadcheck:def>\n  <threadcheck:def>\n    <invariant>\n      <name type=\"only\" value=\"childclass-method1\"/>\n    </invariant>\n    <method name=\"sample.threadCheck.ThreadCheckSample4\" sig=\"run2()V\"/>\n    <foo/>\n  </threadcheck:def>\n</concutest>"));
            List<Node> defs = xc.getNodes("concutest/threadcheck:def");
            Assert.assertEquals(2, defs.size());
            Set<ThreadCheckException> tces = AAddThreadCheckStrategy.checkXMLConcDef(xc);
            XMLConfigTest.assertEquals(1, tces.size());
            XMLConfigTest.assertTrue("Wrong message", tces.contains(new ThreadCheckException("There must be exactly one invariant and at least one class or method per definition, only <invariant>, <class> and <method> are allowed , found 0 <class> and 1 <method>, 1 <invariant>, but 3 children (path: concutest/threadcheck:def/)")));
        }
    }

    public static class XMLConfigException
    extends RuntimeException {
        public XMLConfigException() {
        }

        public XMLConfigException(String message) {
            super(message);
        }

        public XMLConfigException(String message, Throwable cause) {
            super(message, cause);
        }

        public XMLConfigException(Throwable cause) {
            super(cause);
        }
    }
}

