/** Instance: a person's name, year hired, and salary */
public class Employee {
    private String name;      // Employee's name
    private int start;        // Year hired
    private double salary;    // Salary
    
    /** Constructor: a person with name n, year hired d, salary s */
    public Employee(String n, int d, double s) {
        name= n;
        start= d;
        salary= s;
    }
    
    /** Constructor: An person with no name, start date 0, and salary 0. */
    //public Employee() {
    //}
    
    
    /** Constructor: a person with name n, year hired d,
     * salary 50,000 */
    public Employee(String n, int d) {
        this(n, d, 50000);
    }
    
   
    
    /** = name of this Employee */
    public String getName() {
        return name; 
    }
    
    /** Set the name of this Employee to n */
    public void setName(String n)  { 
        name= n; 
    }
    
    /** = year this Employee was hired */
    public int getStart() { 
        return start; 
    }
    
    /** Set the year this Employee was hired to y */
    public void setStart(int y) { 
        start= y; 
    }
    
    /** = Employee's total compensation (here, the salary) */
    public double getCompensation() { 
        return salary; 
    }
    
    /** Change this Employees salary to d */
    public void changeSalary(double d)  { 
        salary= d; 
    }
    
    /** = String representation of this Employee */
    public String toString() {
        return this.getName() + ", year " + getStart() + ", salary " + salary ; 
    }
    
    /** = toString value from superclass */
    public String toStringUp() {
        return super.toString();
    }
    
    /** = e is an Employee, with the same fields as this Employee */
    public boolean equals(Employee e) {
        return e != null
            &&  this.name.equals(e.name)
            &&  this.start == e.start
            &&  this.salary == e.salary;
    }
    

    
 
}
