import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/** This class is used to demo the listening of a return-key stroke
    and a button to make the text field into upper case letters.
  */
public class FieldDemo extends JFrame {
	private JButton b= new JButton("first");
	private JTextField jTF= new JTextField("type here", 20);

	/** Constructor: an invisible frame with a button, 
	              text field, and title t  */
	public FieldDemo(String t) {
		super(t);
		getContentPane().add(b, BorderLayout.WEST);
		b.setEnabled(true);
	
		getContentPane().add(jTF, BorderLayout.EAST);
	
		// Set the actionlistener for components
			b.addActionListener(new MakeUpperCase());
			jTF.addActionListener(new MakeUpperCase());
	   
		pack();
	}
	 
	/** Procedures actionPerformed changes characters in text
	    field jTF to upper case
	  */
	public class MakeUpperCase implements ActionListener {
	    public void actionPerformed(ActionEvent e) {
		    String x= jTF.getText();
		    jTF.setText(x.toUpperCase());
	    }
	}
	
	public static void main(String[] args) {
		FieldDemo fd= new FieldDemo("demo a text field");
		fd.setVisible(true);
	}
}