import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.border.*;

/** This class demos listening to a JComboBox cb. It registers with cb
    both a listener that listens only to selections and a listener
    that listens also to deselections. Each time one of these listeners
    is called, it prints out what kind of listener it is and
    what the item is that caused the event. You can comment out one
    of these listeners to listen only to the other one.
  */
public class ComboBoxListener extends JFrame {
    private JLabel emptyLabel= new JLabel(" ");
    private JComboBox cb= new JComboBox();
     
    /** Constructor: an invisible JFrame with title t, a JComboBox,
                  and a blank label */
    public ComboBoxListener(String t) {
        super(t);
        
        Container cp= getContentPane();
        cp.add(cb,BorderLayout.CENTER);
        cp.add(emptyLabel,BorderLayout.SOUTH);
        
        cb.addActionListener(new SelectionHearer());
        cb.addItemListener(new ItemHearer());
       
        cb.addItem("white");
        cb.addItem("blue");
        cb.addItem("green");
        cb.addItem("pink");
        pack();
    }
    
    /** Procedure actionPerformed prints out "SelectionHearer" 
        followed by the selected item*/
	public class SelectionHearer implements ActionListener {
		public void actionPerformed(ActionEvent e) {
			System.out.println("SelectionHearer: " + cb.getSelectedItem());			                    
		}
	}
	
    /** Procedure itemStateChanged prints out "ItemHearer" followed by 
        the changed item and the kind of change (as an integer)*/
	public class ItemHearer implements ItemListener {
		public void itemStateChanged(ItemEvent e) {
			System.out.println("ItemHearer:" + 
			                   e.getItem() + " " + 
			                   e.getStateChange());
		}
	}
	

    
    public static void main(String[] args) {
    	ComboBoxListener f= new ComboBoxListener("Demo JComboBox listener");
        f.setVisible(true);
    }
 }