import java.awt.*;
import javax.swing.*;

/** Demonstrate placement of components in a JFrame. Use BorderLayout.
    It places five components in the five possible areas:
       (1) a JButton in the east, 
       (2) a JLabel in the west,
       (3) a JLabel in the south,
       (4) a JTextField in the north, and
       (5) a JTextArea in the center.*/
public class ComponentExample extends JFrame {
    /** Constructor: a window with title t and 5 components */
    public ComponentExample(String t) {
        super(t);  
        Container cp=  getContentPane();
        cp.add(new JButton("click me"), BorderLayout.EAST);
        cp.add(new JTextField("type here", 22), BorderLayout.NORTH);
        cp.add(new JCheckBox("I voted today"), BorderLayout.SOUTH);
        cp.add(new JLabel("label 2"), BorderLayout.WEST);
        cp.add(new JTextArea("type\nhere", 4, 10), BorderLayout.CENTER);
        pack();
    }
}