/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.tree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import koala.dynamicjava.tree.AmbiguousName;
import koala.dynamicjava.tree.AnonymousAllocation;
import koala.dynamicjava.tree.ArrayAllocation;
import koala.dynamicjava.tree.ArrayInitializer;
import koala.dynamicjava.tree.ArrayTypeName;
import koala.dynamicjava.tree.BlockStatement;
import koala.dynamicjava.tree.ClassDeclaration;
import koala.dynamicjava.tree.ConstructorCall;
import koala.dynamicjava.tree.ConstructorDeclaration;
import koala.dynamicjava.tree.Declaration;
import koala.dynamicjava.tree.Expression;
import koala.dynamicjava.tree.FieldDeclaration;
import koala.dynamicjava.tree.FormalParameter;
import koala.dynamicjava.tree.Identifier;
import koala.dynamicjava.tree.IfThenStatement;
import koala.dynamicjava.tree.IntTypeName;
import koala.dynamicjava.tree.IntegerLiteral;
import koala.dynamicjava.tree.MethodDeclaration;
import koala.dynamicjava.tree.ModifierSet;
import koala.dynamicjava.tree.Node;
import koala.dynamicjava.tree.ObjectMethodCall;
import koala.dynamicjava.tree.ReferenceTypeName;
import koala.dynamicjava.tree.ReturnStatement;
import koala.dynamicjava.tree.SimpleAllocation;
import koala.dynamicjava.tree.SourceInfo;
import koala.dynamicjava.tree.StaticFieldAccess;
import koala.dynamicjava.tree.StringLiteral;
import koala.dynamicjava.tree.ThrowStatement;
import koala.dynamicjava.tree.VariableAccess;
import koala.dynamicjava.tree.tiger.GenericReferenceTypeName;
import koala.dynamicjava.tree.visitor.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumDeclaration
extends ClassDeclaration {
    public EnumDeclaration(ModifierSet mods, String name, List<? extends ReferenceTypeName> impl, EnumBody body) {
        this(mods, name, impl, body, SourceInfo.NONE);
    }

    public EnumDeclaration(ModifierSet mods, String name, List<? extends ReferenceTypeName> impl, EnumBody body, SourceInfo si) {
        super(mods, name, EnumDeclaration.makeTypeName(name), impl, EnumDeclaration.AddValues(name, EnumDeclaration.HandleConstructors(name, EnumDeclaration.makeEnumBodyDeclarationsFromEnumConsts(name, body)), body.getConstants()), si);
    }

    private static ReferenceTypeName makeTypeName(String name) {
        List<Identifier> c = Arrays.asList(new Identifier("java"), new Identifier("lang"), new Identifier("Enum"));
        List emptyTargs = Collections.emptyList();
        List<ReferenceTypeName> targs = Arrays.asList(new ReferenceTypeName(name));
        LinkedList<List<Object>> allTArgs = new LinkedList<List<Object>>();
        allTArgs.add(emptyTargs);
        allTArgs.add(emptyTargs);
        allTArgs.add(targs);
        return new GenericReferenceTypeName(c, allTArgs);
    }

    static List<Node> AddValues(String enumTypeName, List<Node> body, List<EnumConstant> consts) {
        List<Node> newbody = body;
        ReferenceTypeName enumType = new ReferenceTypeName(enumTypeName);
        LinkedList<StaticFieldAccess> cells = new LinkedList<StaticFieldAccess>();
        for (EnumConstant c : consts) {
            cells.add(new StaticFieldAccess(enumType, c.getName()));
        }
        ArrayAllocation alloc = new ArrayAllocation(enumType, new ArrayAllocation.TypeDescriptor(Collections.emptyList(), 1, new ArrayInitializer(cells), SourceInfo.NONE));
        ReturnStatement valuesBody = new ReturnStatement(alloc);
        newbody.add(new MethodDeclaration(ModifierSet.make(ModifierSet.Modifier.PUBLIC, ModifierSet.Modifier.STATIC), new ArrayTypeName(enumType, 1, false), "values", Collections.<FormalParameter>emptyList(), Collections.emptyList(), new BlockStatement(Collections.singletonList(valuesBody))));
        FormalParameter nameParam = new FormalParameter(ModifierSet.make(), new ReferenceTypeName("java", "lang", "String"), "name");
        LinkedList<Node> valueOfBody = new LinkedList<Node>();
        for (EnumConstant c : consts) {
            String cn = c.getName();
            ObjectMethodCall cond = new ObjectMethodCall(new StringLiteral("\"" + cn + "\""), "equals", Collections.singletonList(new VariableAccess("name")));
            ReturnStatement ret = new ReturnStatement(new StaticFieldAccess(enumType, cn));
            valueOfBody.add(new IfThenStatement(cond, ret));
        }
        valueOfBody.add(new ThrowStatement(new SimpleAllocation(new ReferenceTypeName("IllegalArgumentException"), Collections.emptyList())));
        newbody.add(new MethodDeclaration(ModifierSet.make(ModifierSet.Modifier.PUBLIC, ModifierSet.Modifier.STATIC), enumType, "valueOf", Collections.singletonList(nameParam), Collections.emptyList(), new BlockStatement(valueOfBody)));
        return newbody;
    }

    static List<Node> HandleConstructors(String name, List<Node> body) {
        ListIterator<Node> it = body.listIterator();
        LinkedList<FormalParameter> addToConsDeclaration = new LinkedList<FormalParameter>();
        addToConsDeclaration.add(new FormalParameter(ModifierSet.make(), new ReferenceTypeName("String"), "$1"));
        addToConsDeclaration.add(new FormalParameter(ModifierSet.make(), new IntTypeName(), "$2"));
        LinkedList<AmbiguousName> args = new LinkedList<AmbiguousName>();
        args.add(new AmbiguousName("$1"));
        args.add(new AmbiguousName("$2"));
        boolean noConstructor = true;
        while (it.hasNext()) {
            Node current = (Node)it.next();
            if (!(current instanceof ConstructorDeclaration)) continue;
            noConstructor = false;
            List<FormalParameter> consParams = ((ConstructorDeclaration)current).getParameters();
            LinkedList<FormalParameter> newConsParam = new LinkedList<FormalParameter>();
            newConsParam.addAll(addToConsDeclaration);
            newConsParam.addAll(consParams);
            ((ConstructorDeclaration)current).setParameters(newConsParam);
            ((ConstructorDeclaration)current).setConstructorCall(new ConstructorCall(null, args, true));
        }
        if (noConstructor) {
            body.add(new ConstructorDeclaration(ModifierSet.make(ModifierSet.Modifier.PRIVATE, new ModifierSet.Modifier[0]), name, addToConsDeclaration, new LinkedList(), new ConstructorCall(null, args, true), new LinkedList<Node>()));
        }
        return body;
    }

    static List<Node> makeEnumBodyDeclarationsFromEnumConsts(String enumTypeName, EnumBody body) {
        List<EnumConstant> consts = body.getConstants();
        List<Node> decls = body.getDeclarations();
        ReferenceTypeName enumType = new ReferenceTypeName(enumTypeName);
        SimpleAllocation allocExpr = null;
        ListIterator<EnumConstant> it = consts.listIterator();
        int i = 0;
        while (it.hasNext()) {
            LinkedList<Expression> args = new LinkedList<Expression>();
            EnumConstant ec = (EnumConstant)it.next();
            args.add(new StringLiteral("\"" + ec.getName() + "\""));
            args.add(new IntegerLiteral(String.valueOf(i++)));
            if (ec.getArguments() != null) {
                args.addAll(ec.getArguments());
            }
            allocExpr = ec.getClassBody() != null ? new AnonymousAllocation(enumType, args, ec.getClassBody()) : new SimpleAllocation(enumType, args);
            decls.add(new FieldDeclaration(ModifierSet.make(ModifierSet.Modifier.PUBLIC, ModifierSet.Modifier.STATIC, ModifierSet.Modifier.FINAL, ModifierSet.Modifier.ENUM), enumType, ec.getName(), allocExpr));
        }
        return decls;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EnumBody {
        private List<EnumConstant> consts;
        private List<Node> decls;

        public EnumBody(List<EnumConstant> c, List<Node> d) {
            this.consts = c;
            this.decls = d;
        }

        public List<EnumConstant> getConstants() {
            return this.consts;
        }

        public List<Node> getDeclarations() {
            return this.decls;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EnumConstant
    extends Declaration {
        private String name;
        private List<Expression> args;
        private List<Node> classBody;

        public EnumConstant(ModifierSet mods, String _name, List<? extends Expression> _args, List<Node> _classBody, SourceInfo si) {
            super(mods, si);
            this.name = _name;
            this.args = _args == null ? null : new ArrayList<Expression>(_args);
            this.classBody = _classBody;
        }

        public String getName() {
            return this.name;
        }

        public List<Expression> getArguments() {
            return this.args;
        }

        public List<Node> getClassBody() {
            return this.classBody;
        }

        @Override
        public <T> T acceptVisitor(Visitor<T> visitor) {
            return visitor.visit(this);
        }
    }
}

