/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.tree;

import java.util.LinkedList;
import java.util.List;
import koala.dynamicjava.tree.ContinueTarget;
import koala.dynamicjava.tree.Expression;
import koala.dynamicjava.tree.Node;
import koala.dynamicjava.tree.SourceInfo;
import koala.dynamicjava.tree.Statement;
import koala.dynamicjava.tree.visitor.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoStatement
extends Statement
implements ContinueTarget {
    private Expression condition;
    private Node body;
    private List<String> labels;

    public DoStatement(Expression cond, Node body) {
        this(cond, body, SourceInfo.NONE);
    }

    public DoStatement(Expression cond, Node body, SourceInfo si) {
        super(si);
        if (cond == null) {
            throw new IllegalArgumentException("cond == null");
        }
        if (body == null) {
            throw new IllegalArgumentException("body == null");
        }
        this.condition = cond;
        this.body = body;
        this.labels = new LinkedList<String>();
    }

    public Expression getCondition() {
        return this.condition;
    }

    public void setCondition(Expression e) {
        if (e == null) {
            throw new IllegalArgumentException("e == null");
        }
        this.condition = e;
    }

    public Node getBody() {
        return this.body;
    }

    public void setBody(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("node == null");
        }
        this.body = node;
    }

    @Override
    public void addLabel(String label) {
        if (label == null) {
            throw new IllegalArgumentException("label == null");
        }
        this.labels.add(label);
    }

    @Override
    public boolean hasLabel(String label) {
        return this.labels.contains(label);
    }

    @Override
    public <T> T acceptVisitor(Visitor<T> visitor) {
        return visitor.visit(this);
    }

    public String toString() {
        return "(" + this.getClass().getName() + ": " + this.getCondition() + " " + this.getBody() + ")";
    }
}

