/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.tree;

import koala.dynamicjava.tree.SourceInfo;
import koala.dynamicjava.tree.TypeName;
import koala.dynamicjava.tree.visitor.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayTypeName
extends TypeName {
    private TypeName elementType;
    private boolean vararg;

    public ArrayTypeName(TypeName et, int dim, boolean varg) {
        this(et, dim, varg, SourceInfo.NONE);
    }

    public ArrayTypeName(TypeName et, int dim, boolean varg, SourceInfo si) {
        super(si);
        if (et == null) {
            throw new IllegalArgumentException("et == null");
        }
        if (dim < 1) {
            throw new IllegalArgumentException("dim < 1");
        }
        this.elementType = dim > 1 ? new ArrayTypeName(et, dim - 1, false, si) : et;
        this.vararg = varg;
    }

    public TypeName getElementType() {
        return this.elementType;
    }

    public void setElementType(TypeName t) {
        if (t == null) {
            throw new IllegalArgumentException("t == null");
        }
        this.elementType = t;
    }

    public boolean isVararg() {
        return this.vararg;
    }

    @Override
    public <T> T acceptVisitor(Visitor<T> visitor) {
        return visitor.visit(this);
    }

    public String toString() {
        return "(" + this.getClass().getName() + ": " + this.getElementType() + ")";
    }
}

