/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.util.swing;

import java.awt.Component;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class DirectoryChooser
extends JFileChooser {
    protected Component _owner;
    protected File _root;

    public DirectoryChooser() {
        this(null, null, false, false);
    }

    public DirectoryChooser(Component owner) {
        this(owner, null, false, false);
    }

    public DirectoryChooser(Component owner, boolean allowMultiple) {
        this(owner, null, allowMultiple, false);
    }

    public DirectoryChooser(Component owner, File root) {
        this(owner, root, false, false);
    }

    public DirectoryChooser(Component owner, File root, boolean allowMultiple, boolean showHidden) {
        super(root);
        this._init(owner, root, allowMultiple, showHidden);
    }

    private void _init(Component owner, File root, boolean allowMultiple, boolean showHidden) {
        this._owner = owner;
        this._root = root;
        if (root != null) {
            if (!root.exists()) {
                this._root = null;
            } else if (!root.isDirectory()) {
                this._root = root.getParentFile();
            }
        }
        this.setMultiSelectionEnabled(allowMultiple);
        this.setFileHidingEnabled(!showHidden);
        this.setFileSelectionMode(1);
        this.setDialogType(2);
        this.setApproveButtonText("Select");
        this.setFileFilter(new FileFilter(){

            public boolean accept(File f) {
                return true;
            }

            public String getDescription() {
                return "All Folders";
            }
        });
    }

    public int showDialog(File initialSelection) {
        this.setCurrentDirectory(initialSelection);
        return this.showDialog(this._owner, null);
    }

    public void setOwner(Component owner) {
        this._owner = owner;
    }

    public int showDialog() {
        return this.showDialog(this._owner, null);
    }

    public File[] getSelectedDirectories() {
        return this.getSelectedFiles();
    }

    public File getSelectedDirectory() {
        return this.getSelectedFile();
    }
}

