/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.util.swing;

import edu.rice.cs.util.swing.AsyncCompletionArgs;
import edu.rice.cs.util.swing.AsyncTask;
import edu.rice.cs.util.swing.IAsyncProgress;
import edu.rice.cs.util.swing.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AsyncTaskLauncher {
    protected abstract boolean shouldSetEnabled();

    protected abstract void setParentContainerEnabled(boolean var1);

    protected abstract IAsyncProgress createProgressMonitor(String var1, int var2, int var3);

    public <P, R> void executeTask(final AsyncTask<P, R> task, final P param, boolean showProgress, final boolean lockUI) {
        Runnable uiInit = new Runnable(){

            public void run() {
                final boolean shouldUnlockUI = AsyncTaskLauncher.this.shouldSetEnabled() && lockUI;
                final IAsyncProgress monitor = AsyncTaskLauncher.this.createProgressMonitor(task.getDiscriptionMessage(), task.getMinProgress(), task.getMaxProgress());
                if (AsyncTaskLauncher.this.shouldSetEnabled() && lockUI) {
                    AsyncTaskLauncher.this.setParentContainerEnabled(false);
                }
                Thread taskThread = new Thread(new Runnable(){

                    public void run() {
                        Object result = null;
                        Exception caughtException = null;
                        try {
                            result = task.runAsync(param, monitor);
                        }
                        catch (Exception e) {
                            caughtException = e;
                        }
                        final AsyncCompletionArgs<Object> args = new AsyncCompletionArgs<Object>(result, caughtException, monitor.isCanceled());
                        Runnable cleanup = new Runnable(){

                            public void run() {
                                task.complete(args);
                                if (shouldUnlockUI) {
                                    AsyncTaskLauncher.this.setParentContainerEnabled(true);
                                }
                            }
                        };
                        Utilities.invokeLater(cleanup);
                    }
                }, "Task Thread - " + task.getName());
                taskThread.start();
            }
        };
        Utilities.invokeLater(uiInit);
    }
}

