/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.recur;

import edu.rice.cs.plt.collect.HashMultiset;
import edu.rice.cs.plt.collect.Multiset;
import edu.rice.cs.plt.lambda.Lambda;
import edu.rice.cs.plt.lambda.Runnable1;
import edu.rice.cs.plt.lambda.Thunk;
import edu.rice.cs.plt.tuple.IdentityWrapper;
import edu.rice.cs.plt.tuple.Wrapper;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecursionStack<T> {
    private final Lambda<? super T, ? extends Wrapper<T>> _wrapperFactory;
    private final Multiset<Wrapper<T>> _previous;
    private final LinkedList<Wrapper<T>> _stack;

    public RecursionStack() {
        this(IdentityWrapper.factory());
    }

    public RecursionStack(Lambda<? super T, ? extends Wrapper<T>> wrapperFactory) {
        this._wrapperFactory = wrapperFactory;
        this._previous = new HashMultiset<Wrapper<T>>();
        this._stack = new LinkedList();
    }

    public boolean contains(T arg) {
        return this._previous.contains(this._wrapperFactory.value(arg));
    }

    public boolean contains(T arg, int threshold) {
        return this._previous.count(this._wrapperFactory.value(arg)) >= threshold;
    }

    public void push(T arg) {
        Wrapper<T> wrapped = this._wrapperFactory.value(arg);
        this._stack.addLast(wrapped);
        this._previous.add(wrapped);
    }

    public void pop(T arg) {
        Wrapper<T> wrapped = this._wrapperFactory.value(arg);
        if (this._stack.isEmpty() || !this._stack.getLast().equals(wrapped)) {
            throw new IllegalArgumentException("arg is not on top of the stack");
        }
        this._stack.removeLast();
        this._previous.remove(wrapped);
    }

    public int size() {
        return this._stack.size();
    }

    public boolean isEmpty() {
        return this._stack.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Runnable r, T arg) {
        if (!this.contains(arg)) {
            this.push(arg);
            try {
                r.run();
            }
            finally {
                this.pop(arg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Runnable r, T arg, int threshold) {
        if (!this.contains(arg, threshold)) {
            this.push(arg);
            try {
                r.run();
            }
            finally {
                this.pop(arg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Runnable r, Runnable infiniteCase, T arg) {
        Runnable toRun = this.contains(arg) ? infiniteCase : r;
        this.push(arg);
        try {
            toRun.run();
        }
        finally {
            this.pop(arg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Runnable r, Runnable infiniteCase, T arg, int threshold) {
        Runnable toRun = this.contains(arg, threshold) ? infiniteCase : r;
        this.push(arg);
        try {
            toRun.run();
        }
        finally {
            this.pop(arg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V extends T> void run(Runnable1<? super V> r, V arg) {
        if (!this.contains(arg)) {
            this.push(arg);
            try {
                r.run(arg);
            }
            finally {
                this.pop(arg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V extends T> void run(Runnable1<? super V> r, V arg, int threshold) {
        if (!this.contains(arg, threshold)) {
            this.push(arg);
            try {
                r.run(arg);
            }
            finally {
                this.pop(arg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V extends T> void run(Runnable1<? super V> r, Runnable1<? super V> infiniteCase, V arg) {
        Runnable1<V> toRun = this.contains(arg) ? infiniteCase : r;
        this.push(arg);
        try {
            toRun.run(arg);
        }
        finally {
            this.pop(arg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V extends T> void run(Runnable1<? super V> r, Runnable1<? super V> infiniteCase, V arg, int threshold) {
        Runnable1<V> toRun = this.contains(arg, threshold) ? infiniteCase : r;
        this.push(arg);
        try {
            toRun.run(arg);
        }
        finally {
            this.pop(arg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R apply(Thunk<? extends R> thunk, R infiniteCase, T arg) {
        if (!this.contains(arg)) {
            this.push(arg);
            try {
                R r = thunk.value();
                return r;
            }
            finally {
                this.pop(arg);
            }
        }
        return infiniteCase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R apply(Thunk<? extends R> thunk, R infiniteCase, T arg, int threshold) {
        if (!this.contains(arg, threshold)) {
            this.push(arg);
            try {
                R r = thunk.value();
                return r;
            }
            finally {
                this.pop(arg);
            }
        }
        return infiniteCase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R apply(Thunk<? extends R> thunk, Thunk<? extends R> infiniteCase, T arg) {
        Thunk<R> toApply = this.contains(arg) ? infiniteCase : thunk;
        this.push(arg);
        try {
            R r = toApply.value();
            return r;
        }
        finally {
            this.pop(arg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R apply(Thunk<? extends R> thunk, Thunk<? extends R> infiniteCase, T arg, int threshold) {
        Thunk<R> toApply = this.contains(arg, threshold) ? infiniteCase : thunk;
        this.push(arg);
        try {
            R r = toApply.value();
            return r;
        }
        finally {
            this.pop(arg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V extends T, R> R apply(Lambda<? super V, ? extends R> lambda, R infiniteCase, V arg) {
        if (!this.contains(arg)) {
            this.push(arg);
            try {
                R r = lambda.value(arg);
                return r;
            }
            finally {
                this.pop(arg);
            }
        }
        return infiniteCase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V extends T, R> R apply(Lambda<? super V, ? extends R> lambda, R infiniteCase, V arg, int threshold) {
        if (!this.contains(arg, threshold)) {
            this.push(arg);
            try {
                R r = lambda.value(arg);
                return r;
            }
            finally {
                this.pop(arg);
            }
        }
        return infiniteCase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V extends T, R> R apply(Lambda<? super V, ? extends R> lambda, Lambda<? super V, ? extends R> infiniteCase, V arg) {
        Lambda<V, R> toApply = this.contains(arg) ? infiniteCase : lambda;
        this.push(arg);
        try {
            R r = toApply.value(arg);
            return r;
        }
        finally {
            this.pop(arg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V extends T, R> R apply(Lambda<? super V, ? extends R> lambda, Lambda<? super V, ? extends R> infiniteCase, V arg, int threshold) {
        Lambda<V, R> toApply = this.contains(arg, threshold) ? infiniteCase : lambda;
        this.push(arg);
        try {
            R r = toApply.value(arg);
            return r;
        }
        finally {
            this.pop(arg);
        }
    }

    public static <T> RecursionStack<T> make() {
        return new RecursionStack<T>();
    }

    public static <T> RecursionStack<T> make(Lambda<? super T, ? extends Wrapper<T>> wrapperFactory) {
        return new RecursionStack<T>(wrapperFactory);
    }
}

