/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.iter;

import edu.rice.cs.plt.iter.AbstractIterable;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.iter.SizedIterable;
import edu.rice.cs.plt.iter.SnapshotIterable;
import edu.rice.cs.plt.iter.TruncatedIterator;
import edu.rice.cs.plt.object.Composite;
import edu.rice.cs.plt.object.ObjectUtil;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TruncatedIterable<T>
extends AbstractIterable<T>
implements SizedIterable<T>,
Composite,
Serializable {
    private final Iterable<? extends T> _iterable;
    protected final int _size;

    public TruncatedIterable(Iterable<? extends T> iterable, int size) {
        if (size < 0) {
            throw new IllegalArgumentException("size < 0");
        }
        this._iterable = iterable;
        this._size = size;
    }

    @Override
    public int compositeHeight() {
        return ObjectUtil.compositeHeight(this._iterable) + 1;
    }

    @Override
    public int compositeSize() {
        return ObjectUtil.compositeSize(this._iterable) + 1;
    }

    @Override
    public TruncatedIterator<T> iterator() {
        return new TruncatedIterator<T>(this._iterable.iterator(), this._size);
    }

    @Override
    public boolean isEmpty() {
        return this._size == 0 || IterUtil.isEmpty(this._iterable);
    }

    @Override
    public int size() {
        return IterUtil.sizeOf(this._iterable, this._size);
    }

    @Override
    public int size(int bound) {
        return IterUtil.sizeOf(this._iterable, this._size <= bound ? this._size : bound);
    }

    @Override
    public boolean isInfinite() {
        return false;
    }

    @Override
    public boolean hasFixedSize() {
        return IterUtil.hasFixedSize(this._iterable);
    }

    @Override
    public boolean isStatic() {
        return IterUtil.isStatic(this._iterable);
    }

    public static <T> TruncatedIterable<T> make(Iterable<? extends T> iterable, int size) {
        return new TruncatedIterable<T>(iterable, size);
    }

    public static <T> SnapshotIterable<T> makeSnapshot(Iterable<? extends T> iterable, int size) {
        return new SnapshotIterable<T>(new TruncatedIterable<T>(iterable, size));
    }
}

