/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.debug;

import edu.rice.cs.plt.iter.IterUtil;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Stopwatch {
    private final List<Long> _splits = new LinkedList<Long>();
    private boolean _running = false;
    private long _start;

    public Stopwatch() {
    }

    public Stopwatch(boolean startImmediately) {
        if (startImmediately) {
            this.start();
        }
    }

    public void start() {
        if (this._running) {
            throw new IllegalStateException("Already running");
        }
        this._start = System.currentTimeMillis();
        this._running = true;
    }

    public long split() {
        if (!this._running) {
            throw new IllegalStateException("Not running");
        }
        long result = System.currentTimeMillis() - this._start;
        this._splits.add(result);
        return result;
    }

    public long stop() {
        long result = this.split();
        this._running = false;
        return result;
    }

    public Iterable<Long> splits() {
        return IterUtil.immutable(this._splits);
    }
}

