/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.concurrent;

import edu.rice.cs.plt.collect.ListenerSet;
import edu.rice.cs.plt.collect.SnapshotSynchronizedSet;
import edu.rice.cs.plt.concurrent.CompletionMonitor;
import edu.rice.cs.plt.lambda.ResolvingThunk;
import edu.rice.cs.plt.lambda.WrappedException;
import edu.rice.cs.plt.tuple.Option;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TaskController<R>
implements ResolvingThunk<R>,
Future<R> {
    protected final AtomicReference<State> state = new AtomicReference<FreshState>(new FreshState());
    private final CompletionMonitor _done = new CompletionMonitor();
    private volatile ListenerSet<R> _finishListeners = new ListenerSet(SnapshotSynchronizedSet.makeLinkedHash());

    protected TaskController() {
    }

    public Status status() {
        return this.state.get().status();
    }

    @Override
    public boolean isDone() {
        Status s = this.status();
        return s == Status.FINISHED || s == Status.CANCELED;
    }

    public boolean hasValue() {
        return this.status() == Status.FINISHED;
    }

    public boolean isCanceled() {
        return this.status() == Status.CANCELED;
    }

    @Override
    public boolean isCancelled() {
        return this.status() == Status.CANCELED;
    }

    @Override
    public boolean isResolved() {
        return this.state.get() instanceof CleanlyFinishedState;
    }

    public void start() {
        this.state.get().start();
    }

    public boolean cancel() {
        return this.state.get().cancel(true);
    }

    @Override
    public boolean cancel(boolean stopRunning) {
        return this.state.get().cancel(stopRunning);
    }

    @Override
    public R value() {
        try {
            return this.state.get().get();
        }
        catch (Exception e) {
            throw new WrappedException(e);
        }
    }

    @Override
    public R get() throws InterruptedException, ExecutionException {
        return this.state.get().get();
    }

    public R get(long timeout) throws InterruptedException, ExecutionException, TimeoutException {
        return this.get(timeout, TimeUnit.MILLISECONDS);
    }

    @Override
    public R get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.state.get().get(timeout, unit);
    }

    public Option<R> attemptGet(long timeout) throws ExecutionException {
        try {
            return Option.some(this.get(timeout, TimeUnit.MILLISECONDS));
        }
        catch (InterruptedException e) {
            return Option.none();
        }
        catch (TimeoutException e) {
            return Option.none();
        }
    }

    public Option<R> attemptGet(long timeout, TimeUnit unit) throws ExecutionException {
        try {
            return Option.some(this.get(timeout, unit));
        }
        catch (InterruptedException e) {
            return Option.none();
        }
        catch (TimeoutException e) {
            return Option.none();
        }
    }

    public ListenerSet.Sink finishListeners() {
        return this._finishListeners.sink();
    }

    protected abstract void doStart();

    protected abstract void doStop();

    protected void discard() {
    }

    protected final void started() {
        boolean kept = false;
        State current = this.state.get();
        RunningState next = this.runningState();
        while (current instanceof StartingState && !kept) {
            kept = this.state.weakCompareAndSet(current, next);
            if (kept) {
                ((StartingState)current).started();
                continue;
            }
            current = this.state.get();
        }
    }

    protected final void stopped() {
        this.finished(new CanceledState());
    }

    protected final void finishedCleanly(R result) {
        this.finished(new CleanlyFinishedState(result));
        this._finishListeners.run(result);
        this._finishListeners.clear();
    }

    protected final void finishedWithTaskException(Exception e) {
        this.finished(new ExecutionExceptionState(new ExecutionException(e)));
    }

    protected final void finishedWithImplementationException(RuntimeException e) {
        this.finished(new InternalExceptionState(e));
    }

    private final void finished(State finishedState) {
        State current = this.state.get();
        boolean changed = false;
        while (!changed && current.status() != Status.CANCELED && current.status() != Status.FINISHED) {
            changed = this.state.weakCompareAndSet(current, finishedState);
            if (changed) {
                this._done.signal();
                this.discard();
                continue;
            }
            current = this.state.get();
        }
    }

    protected RunningState runningState() {
        return new RunningState();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class CanceledState
    extends State {
        protected CanceledState() {
        }

        @Override
        public Status status() {
            return Status.CANCELED;
        }

        @Override
        public void start() {
            throw new CancellationException("Task is canceled");
        }

        @Override
        public boolean cancel(boolean stopRunning) {
            return false;
        }

        @Override
        public R get() {
            throw new CancellationException("Task is canceled");
        }

        @Override
        public R get(long timeout, TimeUnit u) {
            throw new CancellationException("Task is canceled");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class InternalExceptionState
    extends FinishedState {
        private RuntimeException _e;

        public InternalExceptionState(RuntimeException e) {
            this._e = e;
        }

        @Override
        public R get() {
            throw this._e;
        }

        @Override
        public R get(long timeout, TimeUnit u) throws ExecutionException {
            throw this._e;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ExecutionExceptionState
    extends FinishedState {
        private ExecutionException _e;

        public ExecutionExceptionState(ExecutionException e) {
            this._e = e;
        }

        @Override
        public R get() throws ExecutionException {
            throw this._e;
        }

        @Override
        public R get(long timeout, TimeUnit u) throws ExecutionException {
            throw this._e;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class CleanlyFinishedState
    extends FinishedState {
        private R _result;

        public CleanlyFinishedState(R result) {
            this._result = result;
        }

        @Override
        public R get() {
            return this._result;
        }

        @Override
        public R get(long timeout, TimeUnit u) {
            return this._result;
        }
    }

    protected abstract class FinishedState
    extends State {
        protected FinishedState() {
        }

        public Status status() {
            return Status.FINISHED;
        }

        public void start() {
        }

        public boolean cancel(boolean stopRunning) {
            return false;
        }
    }

    protected class CancelingState
    extends ComputingState {
        protected CancelingState() {
        }

        public Status status() {
            return Status.RUNNING;
        }

        public void start() {
        }

        public boolean cancel(boolean stopRunning) {
            return stopRunning;
        }
    }

    protected class RunningState
    extends ComputingState {
        protected RunningState() {
        }

        public Status status() {
            return Status.RUNNING;
        }

        public void start() {
        }

        public boolean cancel(boolean stopRunning) {
            if (stopRunning) {
                if (TaskController.this.state.compareAndSet(this, new CancelingState())) {
                    TaskController.this.doStop();
                    return true;
                }
                return TaskController.this.state.get().cancel(stopRunning);
            }
            return false;
        }
    }

    protected class CanceledStartingState
    extends StartingState {
        protected CanceledStartingState() {
        }

        public boolean cancel(boolean stopRunning) {
            return stopRunning;
        }

        public void started() {
            TaskController.this.state.get().cancel(true);
        }
    }

    protected class FreshStartingState
    extends StartingState {
        protected FreshStartingState() {
        }

        public void started() {
        }
    }

    protected abstract class StartingState
    extends ComputingState {
        protected StartingState() {
        }

        public Status status() {
            return Status.PAUSED;
        }

        public void start() {
        }

        public boolean cancel(boolean stopRunning) {
            if (stopRunning) {
                if (TaskController.this.state.compareAndSet(this, new CanceledStartingState())) {
                    return true;
                }
                return TaskController.this.state.get().cancel(stopRunning);
            }
            return false;
        }

        public abstract void started();
    }

    protected class FreshState
    extends WaitingState {
        protected FreshState() {
        }

        public void start() {
            if (TaskController.this.state.compareAndSet(this, new FreshStartingState())) {
                TaskController.this.doStart();
            } else {
                TaskController.this.state.get().start();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class ComputingState
    extends State {
        protected ComputingState() {
        }

        @Override
        public R get() throws InterruptedException, ExecutionException {
            TaskController.this._done.ensureSignaled();
            return TaskController.this.state.get().get();
        }

        @Override
        public R get(long timeout, TimeUnit u) throws InterruptedException, ExecutionException, TimeoutException {
            TaskController.this._done.ensureSignaled(timeout, u);
            return TaskController.this.state.get().get();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class WaitingState
    extends State {
        protected WaitingState() {
        }

        @Override
        public Status status() {
            return Status.PAUSED;
        }

        @Override
        public boolean cancel(boolean stopRunning) {
            if (TaskController.this.state.compareAndSet(this, new CanceledState())) {
                TaskController.this._done.signal();
                TaskController.this.discard();
                return true;
            }
            return TaskController.this.state.get().cancel(stopRunning);
        }

        @Override
        public R get() throws InterruptedException, ExecutionException {
            this.start();
            return TaskController.this.state.get().get();
        }

        @Override
        public R get(long timeout, TimeUnit u) throws InterruptedException, ExecutionException, TimeoutException {
            this.start();
            return TaskController.this.state.get().get(timeout, u);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class State {
        protected State() {
        }

        public abstract Status status();

        public abstract void start();

        public abstract boolean cancel(boolean var1);

        public abstract R get() throws InterruptedException, ExecutionException;

        public abstract R get(long var1, TimeUnit var3) throws InterruptedException, ExecutionException, TimeoutException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        PAUSED,
        RUNNING,
        FINISHED,
        CANCELED;

    }
}

