/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.concurrent;

import edu.rice.cs.plt.collect.CollectUtil;
import edu.rice.cs.plt.io.IOUtil;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.iter.SizedIterable;
import edu.rice.cs.plt.lambda.Lambda2;
import edu.rice.cs.plt.lambda.WrappedException;
import edu.rice.cs.plt.reflect.ReflectUtil;
import edu.rice.cs.plt.text.TextUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JVMBuilder
implements Lambda2<String, Iterable<? extends String>, Process> {
    private static final String DEFAULT_JAVA_COMMAND = JVMBuilder.findJavaCommand(System.getProperty("java.home", ""));
    private static final SizedIterable<String> DEFAULT_JVM_ARGS = IterUtil.empty();
    private static final SizedIterable<File> DEFAULT_CLASS_PATH = IOUtil.attemptAbsoluteFiles(ReflectUtil.SYSTEM_CLASS_PATH);
    private static final File DEFAULT_DIR = IOUtil.WORKING_DIRECTORY;
    private static final Map<String, String> DEFAULT_PROPERTIES = Collections.emptyMap();
    private static final Map<String, String> DEFAULT_ENVIRONMENT = null;
    public static final JVMBuilder DEFAULT = new JVMBuilder();
    private final String _javaCommand;
    private final SizedIterable<String> _jvmArgs;
    private final SizedIterable<File> _classPath;
    private final File _dir;
    private final Map<String, String> _properties;
    private final Map<String, String> _environment;

    private JVMBuilder() {
        this(DEFAULT_JAVA_COMMAND, DEFAULT_JVM_ARGS, DEFAULT_CLASS_PATH, DEFAULT_DIR, DEFAULT_PROPERTIES, DEFAULT_ENVIRONMENT, true);
    }

    public JVMBuilder(String javaCommand) {
        this(JVMBuilder.findJavaCommand(javaCommand), DEFAULT_JVM_ARGS, DEFAULT_CLASS_PATH, DEFAULT_DIR, DEFAULT_PROPERTIES, DEFAULT_ENVIRONMENT, true);
    }

    public JVMBuilder(String javaCommand, Iterable<? extends String> jvmArgs) {
        this(JVMBuilder.findJavaCommand(javaCommand), IterUtil.snapshot(jvmArgs), DEFAULT_CLASS_PATH, DEFAULT_DIR, DEFAULT_PROPERTIES, DEFAULT_ENVIRONMENT, true);
    }

    public JVMBuilder(Iterable<? extends File> classPath) {
        this(DEFAULT_JAVA_COMMAND, DEFAULT_JVM_ARGS, IOUtil.attemptAbsoluteFiles(classPath), DEFAULT_DIR, DEFAULT_PROPERTIES, DEFAULT_ENVIRONMENT, true);
    }

    public JVMBuilder(File dir) {
        this(DEFAULT_JAVA_COMMAND, DEFAULT_JVM_ARGS, DEFAULT_CLASS_PATH, dir, DEFAULT_PROPERTIES, DEFAULT_ENVIRONMENT, true);
    }

    public JVMBuilder(String javaCommand, Iterable<? extends String> jvmArgs, Iterable<? extends File> classPath, File dir, Map<? extends String, ? extends String> properties, Map<? extends String, ? extends String> environment) {
        this(JVMBuilder.findJavaCommand(javaCommand), IterUtil.snapshot(jvmArgs), IOUtil.attemptAbsoluteFiles(classPath), dir, CollectUtil.snapshot(properties), environment == null ? null : CollectUtil.snapshot(environment), true);
    }

    private JVMBuilder(String javaCommand, SizedIterable<String> jvmArgs, SizedIterable<File> classPath, File dir, Map<String, String> properties, Map<String, String> environment, boolean dummy) {
        this._javaCommand = javaCommand;
        this._jvmArgs = jvmArgs;
        this._classPath = classPath;
        this._dir = dir;
        this._properties = properties;
        this._environment = environment;
    }

    public String javaCommand() {
        return this._javaCommand;
    }

    public JVMBuilder javaCommand(String javaCommand) {
        return new JVMBuilder(JVMBuilder.findJavaCommand(javaCommand), this._jvmArgs, this._classPath, this._dir, this._properties, this._environment, true);
    }

    public JVMBuilder javaCommand(File javaCommand) {
        return new JVMBuilder(JVMBuilder.findJavaCommand(javaCommand), this._jvmArgs, this._classPath, this._dir, this._properties, this._environment, true);
    }

    public SizedIterable<String> jvmArguments() {
        return this._jvmArgs;
    }

    public JVMBuilder jvmArguments(Iterable<? extends String> jvmArgs) {
        return new JVMBuilder(this._javaCommand, IterUtil.snapshot(jvmArgs), this._classPath, this._dir, this._properties, this._environment, true);
    }

    public JVMBuilder jvmArguments(String ... jvmArgs) {
        return new JVMBuilder(this._javaCommand, IterUtil.make(jvmArgs), this._classPath, this._dir, this._properties, this._environment, true);
    }

    public SizedIterable<File> classPath() {
        return this._classPath;
    }

    public JVMBuilder classPath(Iterable<? extends File> classPath) {
        return new JVMBuilder(this._javaCommand, this._jvmArgs, IOUtil.attemptAbsoluteFiles(classPath), this._dir, this._properties, this._environment, true);
    }

    public JVMBuilder classPath(String classPath) {
        return new JVMBuilder(this._javaCommand, this._jvmArgs, IOUtil.attemptAbsoluteFiles(IOUtil.parsePath(classPath)), this._dir, this._properties, this._environment, true);
    }

    public JVMBuilder classPath(File ... classPath) {
        return new JVMBuilder(this._javaCommand, this._jvmArgs, IOUtil.attemptAbsoluteFiles(IterUtil.asIterable(classPath)), this._dir, this._properties, this._environment, true);
    }

    public File directory() {
        return this._dir;
    }

    public JVMBuilder directory(File dir) {
        return new JVMBuilder(this._javaCommand, this._jvmArgs, this._classPath, dir, this._properties, this._environment, true);
    }

    public JVMBuilder directory(String dir) {
        return new JVMBuilder(this._javaCommand, this._jvmArgs, this._classPath, new File(dir), this._properties, this._environment, true);
    }

    public Map<String, String> properties() {
        return CollectUtil.immutable(this._properties);
    }

    public Map<String, String> propertiesCopy() {
        return CollectUtil.snapshot(this._properties);
    }

    public JVMBuilder properties(Properties ps) {
        return new JVMBuilder(this._javaCommand, this._jvmArgs, this._classPath, this._dir, JVMBuilder.copyProps(ps), this._environment, true);
    }

    public JVMBuilder properties(Map<? extends String, ? extends String> ps) {
        return new JVMBuilder(this._javaCommand, this._jvmArgs, this._classPath, this._dir, CollectUtil.snapshot(ps), this._environment, true);
    }

    public JVMBuilder addProperty(String key, String value) {
        Map<String, String> newProps = this.propertiesCopy();
        newProps.put(key, value);
        return this.properties(newProps);
    }

    public JVMBuilder addDefaultProperties(Properties ps) {
        return this.addDefaultProperties(JVMBuilder.copyProps(ps));
    }

    public JVMBuilder addDefaultProperties(Map<? extends String, ? extends String> ps) {
        if (this._properties.keySet().containsAll(ps.keySet())) {
            return this;
        }
        Map<String, String> newProps = this.propertiesCopy();
        for (Map.Entry<? extends String, ? extends String> entry : ps.entrySet()) {
            if (newProps.containsKey(entry.getKey())) continue;
            newProps.put(entry.getKey(), entry.getValue());
        }
        return this.properties(newProps);
    }

    public JVMBuilder addDefaultProperty(String key, String value) {
        return this._properties.containsKey(key) ? this : this.addProperty(key, value);
    }

    public Map<String, String> environment() {
        return this._environment == null ? null : CollectUtil.immutable(this._environment);
    }

    public Map<String, String> environmentCopy() {
        return CollectUtil.snapshot(this._environment == null ? System.getenv() : this._environment);
    }

    public JVMBuilder environment(Map<? extends String, ? extends String> env) {
        return new JVMBuilder(this._javaCommand, this._jvmArgs, this._classPath, this._dir, this._properties, this._environment == null ? null : CollectUtil.snapshot(env), true);
    }

    public JVMBuilder addEnvironmentVar(String key, String value) {
        Map<String, String> newEnv = this.environmentCopy();
        newEnv.put(key, value);
        return this.environment(newEnv);
    }

    public JVMBuilder addDefaultEnvironmentVars(Map<? extends String, ? extends String> env) {
        if (this._environment != null && this._environment.keySet().containsAll(env.keySet())) {
            return this;
        }
        Map<String, String> newEnv = this.environmentCopy();
        for (Map.Entry<? extends String, ? extends String> entry : env.entrySet()) {
            if (newEnv.containsKey(entry.getKey())) continue;
            newEnv.put(entry.getKey(), entry.getValue());
        }
        return this.environment(newEnv);
    }

    public JVMBuilder AddDefaultEnvironmentVar(String key, String value) {
        if (this._environment != null && this._environment.containsKey(key)) {
            return this;
        }
        return this.addEnvironmentVar(key, value);
    }

    public Process start(String mainClass, String ... mainParams) throws IOException {
        return this.start(mainClass, IterUtil.asIterable(mainParams));
    }

    public Process start(String mainClass, Iterable<? extends String> mainParams) throws IOException {
        String[] env;
        LinkedList<String> commandL = new LinkedList<String>();
        commandL.add(this._javaCommand);
        CollectUtil.addAll(commandL, this._jvmArgs);
        commandL.add("-classpath");
        commandL.add(IOUtil.pathToString(this._classPath));
        for (Map.Entry<String, String> prop : this._properties.entrySet()) {
            commandL.add("-D" + prop.getKey() + "=" + prop.getValue());
        }
        commandL.add(mainClass);
        CollectUtil.addAll(commandL, mainParams);
        String[] command = IterUtil.toArray(commandL, String.class);
        if (this._environment == null) {
            env = null;
        } else {
            LinkedList<String> envL = new LinkedList<String>();
            for (Map.Entry<String, String> binding : this._environment.entrySet()) {
                envL.add(binding.getKey() + "=" + binding.getValue());
            }
            env = IterUtil.toArray(envL, String.class);
        }
        return Runtime.getRuntime().exec(command, env, this._dir);
    }

    @Override
    public Process value(String mainClass, Iterable<? extends String> mainParams) {
        try {
            return this.start(mainClass, mainParams);
        }
        catch (IOException e) {
            throw new WrappedException(e);
        }
    }

    private static String findJavaCommand(String command) {
        return JVMBuilder.findJavaCommand(new File(command));
    }

    private static String findJavaCommand(File f) {
        block7: {
            if (IOUtil.attemptIsFile(f)) {
                return f.getPath();
            }
            if (!IOUtil.attemptIsDirectory(f)) break block7;
            f = IOUtil.attemptAbsoluteFile(f);
            String os = System.getProperty("os.name", "");
            File[] candidates = new File[]{new File(f, "../bin"), new File(f, "bin"), f};
            if (!TextUtil.containsIgnoreCase(os, "netware")) {
                if (TextUtil.containsIgnoreCase(os, "windows")) {
                    for (File dir : candidates) {
                        File result = new File(dir, "javaw.exe");
                        if (IOUtil.attemptExists(result)) {
                            return result.getPath();
                        }
                        result = new File(dir, "java.exe");
                        if (!IOUtil.attemptExists(result)) continue;
                        return result.getPath();
                    }
                } else {
                    for (File dir : candidates) {
                        File result = new File(dir, "java");
                        if (!IOUtil.attemptExists(result)) continue;
                        return result.getPath();
                    }
                }
            }
        }
        return f.toString();
    }

    private static Map<String, String> copyProps(Properties p) {
        HashMap<String, String> result = new HashMap<String, String>();
        Enumeration<?> names = p.propertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            result.put(name, p.getProperty(name));
        }
        return result;
    }
}

