/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.concurrent;

import edu.rice.cs.plt.concurrent.ConcurrentUtil;
import edu.rice.cs.plt.lambda.Condition;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class CompletionMonitor
implements Condition {
    private volatile boolean _signal;

    public CompletionMonitor() {
        this._signal = false;
    }

    public CompletionMonitor(boolean signaled) {
        this._signal = signaled;
    }

    public boolean isSignaled() {
        return this._signal;
    }

    public boolean isTrue() {
        return this._signal;
    }

    public void reset() {
        this._signal = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signal() {
        if (!this._signal) {
            CompletionMonitor completionMonitor = this;
            synchronized (completionMonitor) {
                if (!this._signal) {
                    this._signal = true;
                    this.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureSignaled() throws InterruptedException {
        if (!this._signal) {
            CompletionMonitor completionMonitor = this;
            synchronized (completionMonitor) {
                while (!this._signal) {
                    this.wait();
                }
            }
        }
    }

    public void ensureSignaled(long timeout) throws InterruptedException, TimeoutException {
        this.ensureSignaled(timeout, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureSignaled(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        if (!this._signal) {
            long timeoutTime = ConcurrentUtil.futureTimeNanos(timeout, unit);
            CompletionMonitor completionMonitor = this;
            synchronized (completionMonitor) {
                while (!this._signal) {
                    ConcurrentUtil.waitUntilNanos(this, timeoutTime);
                }
            }
        }
    }

    public boolean attemptEnsureSignaled() {
        try {
            this.ensureSignaled();
            return true;
        }
        catch (InterruptedException e) {
            return this._signal;
        }
    }

    public boolean attemptEnsureSignaled(long timeout) {
        try {
            this.ensureSignaled(timeout, TimeUnit.MILLISECONDS);
            return true;
        }
        catch (InterruptedException e) {
            return this._signal;
        }
        catch (TimeoutException e) {
            return this._signal;
        }
    }

    public boolean attemptEnsureSignaled(long timeout, TimeUnit unit) {
        try {
            this.ensureSignaled(timeout, unit);
            return true;
        }
        catch (InterruptedException e) {
            return this._signal;
        }
        catch (TimeoutException e) {
            return this._signal;
        }
    }
}

