/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.dynamicjava.interpreter;

import edu.rice.cs.dynamicjava.Options;
import edu.rice.cs.dynamicjava.interpreter.AmbiguousNameException;
import edu.rice.cs.dynamicjava.interpreter.TypeContext;
import edu.rice.cs.dynamicjava.symbol.BoundedSymbol;
import edu.rice.cs.dynamicjava.symbol.DJClass;
import edu.rice.cs.dynamicjava.symbol.TypeSystem;
import edu.rice.cs.dynamicjava.symbol.type.ArrayType;
import edu.rice.cs.dynamicjava.symbol.type.ClassType;
import edu.rice.cs.dynamicjava.symbol.type.IntersectionType;
import edu.rice.cs.dynamicjava.symbol.type.SimpleArrayType;
import edu.rice.cs.dynamicjava.symbol.type.Type;
import edu.rice.cs.dynamicjava.symbol.type.ValidType;
import edu.rice.cs.dynamicjava.symbol.type.VarargArrayType;
import edu.rice.cs.dynamicjava.symbol.type.VariableType;
import edu.rice.cs.dynamicjava.symbol.type.Wildcard;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.iter.SnapshotIterable;
import edu.rice.cs.plt.lambda.Lambda;
import java.util.Iterator;
import java.util.List;
import koala.dynamicjava.interpreter.NodeProperties;
import koala.dynamicjava.interpreter.error.ExecutionError;
import koala.dynamicjava.tree.ArrayTypeName;
import koala.dynamicjava.tree.BooleanTypeName;
import koala.dynamicjava.tree.ByteTypeName;
import koala.dynamicjava.tree.CharTypeName;
import koala.dynamicjava.tree.DoubleTypeName;
import koala.dynamicjava.tree.FloatTypeName;
import koala.dynamicjava.tree.IdentifierToken;
import koala.dynamicjava.tree.IntTypeName;
import koala.dynamicjava.tree.LongTypeName;
import koala.dynamicjava.tree.ReferenceTypeName;
import koala.dynamicjava.tree.ShortTypeName;
import koala.dynamicjava.tree.TypeName;
import koala.dynamicjava.tree.VoidTypeName;
import koala.dynamicjava.tree.tiger.GenericReferenceTypeName;
import koala.dynamicjava.tree.tiger.HookTypeName;
import koala.dynamicjava.tree.tiger.TypeParameter;
import koala.dynamicjava.tree.visitor.AbstractVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeNameChecker {
    private final TypeContext context;
    private final TypeSystem ts;
    private final Options opt;
    private final TypeNameVisitor visitor;

    public TypeNameChecker(TypeContext ctx, Options options) {
        this.context = ctx;
        this.ts = options.typeSystem();
        this.opt = options;
        this.visitor = new TypeNameVisitor();
    }

    public Type check(TypeName t) {
        Type result = t.acceptVisitor(this.visitor);
        this.ensureWellFormed(t);
        return result;
    }

    public Type checkStructure(TypeName t) {
        return t.acceptVisitor(this.visitor);
    }

    public void ensureWellFormed(TypeName t) {
        if (!this.ts.isWellFormed(NodeProperties.getType(t))) {
            throw new ExecutionError("malformed.type", t);
        }
    }

    public Iterable<Type> checkList(Iterable<? extends TypeName> l) {
        SnapshotIterable<Type> result = IterUtil.mapSnapshot(l, this.visitor);
        this.ensureWellFormedList(l);
        return result;
    }

    public Iterable<Type> checkStructureForList(Iterable<? extends TypeName> l) {
        SnapshotIterable<Type> result = IterUtil.mapSnapshot(l, this.visitor);
        return result;
    }

    public void ensureWellFormedList(Iterable<? extends TypeName> l) {
        for (TypeName typeName : l) {
            this.ensureWellFormed(typeName);
        }
    }

    public void checkTypeParameters(Iterable<? extends TypeParameter> tparams) {
        this.checkStructureForTypeParameters(tparams);
        this.ensureWellFormedTypeParameters(tparams);
    }

    public void checkStructureForTypeParameters(Iterable<? extends TypeParameter> tparams) {
        for (TypeParameter typeParameter : tparams) {
            NodeProperties.setTypeVariable(typeParameter, new VariableType(new BoundedSymbol(typeParameter, typeParameter.getRepresentation())));
        }
        for (TypeParameter typeParameter : tparams) {
            Type upperBound = this.checkStructure(typeParameter.getBound());
            if (!typeParameter.getInterfaceBounds().isEmpty()) {
                upperBound = new IntersectionType(IterUtil.compose(upperBound, this.checkList(typeParameter.getInterfaceBounds())));
            }
            BoundedSymbol b = NodeProperties.getTypeVariable(typeParameter).symbol();
            b.initializeUpperBound(upperBound);
            b.initializeLowerBound(TypeSystem.NULL);
        }
    }

    public void ensureWellFormedTypeParameters(Iterable<? extends TypeParameter> tparams) {
        for (TypeParameter typeParameter : tparams) {
            if (this.ts.isWellFormed(NodeProperties.getTypeVariable(typeParameter))) continue;
            throw new ExecutionError("malformed.type", typeParameter);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TypeNameVisitor
    extends AbstractVisitor<Type>
    implements Lambda<TypeName, Type> {
        private TypeNameVisitor() {
        }

        @Override
        public Type value(TypeName t) {
            return t.acceptVisitor(this);
        }

        @Override
        public Type visit(BooleanTypeName node) {
            return NodeProperties.setType(node, TypeSystem.BOOLEAN);
        }

        @Override
        public Type visit(ByteTypeName node) {
            return NodeProperties.setType(node, TypeSystem.BYTE);
        }

        @Override
        public Type visit(ShortTypeName node) {
            return NodeProperties.setType(node, TypeSystem.SHORT);
        }

        @Override
        public Type visit(CharTypeName node) {
            return NodeProperties.setType(node, TypeSystem.CHAR);
        }

        @Override
        public Type visit(IntTypeName node) {
            return NodeProperties.setType(node, TypeSystem.INT);
        }

        @Override
        public Type visit(LongTypeName node) {
            return NodeProperties.setType(node, TypeSystem.LONG);
        }

        @Override
        public Type visit(FloatTypeName node) {
            return NodeProperties.setType(node, TypeSystem.FLOAT);
        }

        @Override
        public Type visit(DoubleTypeName node) {
            return NodeProperties.setType(node, TypeSystem.DOUBLE);
        }

        @Override
        public Type visit(VoidTypeName node) {
            return NodeProperties.setType(node, TypeSystem.VOID);
        }

        @Override
        public Type visit(ReferenceTypeName node) {
            Iterator<? extends IdentifierToken> ids = node.getIdentifiers().iterator();
            String name = "";
            ValidType t = null;
            boolean first = true;
            while (t == null && ids.hasNext()) {
                if (!first) {
                    name = name + ".";
                }
                first = false;
                name = name + ids.next().image();
                try {
                    ClassType outer;
                    DJClass c = TypeNameChecker.this.context.getTopLevelClass(name, TypeNameChecker.this.ts);
                    if (c != null) {
                        t = TypeNameChecker.this.ts.makeClassType(c);
                        continue;
                    }
                    t = TypeNameChecker.this.context.getTypeVariable(name, TypeNameChecker.this.ts);
                    if (t != null || (outer = TypeNameChecker.this.context.typeContainingMemberClass(name, TypeNameChecker.this.ts)) == null) continue;
                    t = TypeNameChecker.this.ts.lookupClass(outer, name, IterUtil.empty(), TypeNameChecker.this.context.accessModule());
                }
                catch (AmbiguousNameException e) {
                    NodeProperties.setErrorStrings(node, name);
                    throw new ExecutionError("ambiguous.name", node);
                }
                catch (TypeSystem.InvalidTypeArgumentException e) {
                    throw new ExecutionError("type.argument.arity", node);
                }
                catch (TypeSystem.UnmatchedLookupException e) {
                    if (e.matches() == 0) {
                        throw new ExecutionError("undefined.name.noinfo", node);
                    }
                    NodeProperties.setErrorStrings(node, name);
                    throw new ExecutionError("ambiguous.name", node);
                }
            }
            while (ids.hasNext()) {
                String nextId = ids.next().image();
                try {
                    ClassType memberType;
                    t = memberType = TypeNameChecker.this.ts.lookupClass(t, nextId, IterUtil.empty(), TypeNameChecker.this.context.accessModule());
                }
                catch (TypeSystem.InvalidTypeArgumentException e) {
                    throw new ExecutionError("type.argument.arity", node);
                }
                catch (TypeSystem.UnmatchedLookupException e) {
                    if (e.matches() == 0) {
                        throw new ExecutionError("undefined.name.noinfo", node);
                    }
                    NodeProperties.setErrorStrings(node, nextId);
                    throw new ExecutionError("ambiguous.name", node);
                }
            }
            if (t == null) {
                NodeProperties.setErrorStrings(node, node.getRepresentation());
                throw new ExecutionError("undefined.class", node);
            }
            return NodeProperties.setType(node, t);
        }

        @Override
        public Type visit(GenericReferenceTypeName node) {
            Iterable<Type> targs;
            Iterator<? extends IdentifierToken> ids = node.getIdentifiers().iterator();
            Iterator<? extends List<? extends TypeName>> allTargs = node.getTypeArguments().iterator();
            String name = "";
            ValidType t = null;
            boolean first = true;
            while (t == null && ids.hasNext()) {
                if (!first) {
                    name = name + ".";
                }
                first = false;
                name = name + ids.next().image();
                List<? extends TypeName> targsNames = allTargs.next();
                targs = TypeNameChecker.this.checkStructureForList(targsNames);
                try {
                    ClassType outer;
                    DJClass c = TypeNameChecker.this.context.getTopLevelClass(name, TypeNameChecker.this.ts);
                    ClassType classType = t = c == null ? null : TypeNameChecker.this.ts.makeClassType(c, targs);
                    if (t == null && (outer = TypeNameChecker.this.context.typeContainingMemberClass(name, TypeNameChecker.this.ts)) != null) {
                        t = TypeNameChecker.this.ts.lookupClass(outer, name, targs, TypeNameChecker.this.context.accessModule());
                    }
                    if (t != null) continue;
                    if (!IterUtil.isEmpty(targs)) {
                        NodeProperties.setErrorStrings(node, name);
                        throw new ExecutionError("undefined.class", node);
                    }
                    t = TypeNameChecker.this.context.getTypeVariable(name, TypeNameChecker.this.ts);
                }
                catch (AmbiguousNameException e) {
                    NodeProperties.setErrorStrings(node, name);
                    throw new ExecutionError("ambiguous.name", node);
                }
                catch (TypeSystem.InvalidTypeArgumentException e) {
                    throw new ExecutionError("type.argument.arity", node);
                }
                catch (TypeSystem.UnmatchedLookupException e) {
                    if (e.matches() == 0) {
                        throw new ExecutionError("undefined.name.noinfo", node);
                    }
                    NodeProperties.setErrorStrings(node, name);
                    throw new ExecutionError("ambiguous.name", node);
                }
            }
            while (ids.hasNext()) {
                String nextId = ids.next().image();
                try {
                    ClassType memberType;
                    targs = TypeNameChecker.this.checkStructureForList((Iterable<? extends TypeName>)allTargs.next());
                    t = memberType = TypeNameChecker.this.ts.lookupClass(t, nextId, targs, TypeNameChecker.this.context.accessModule());
                }
                catch (TypeSystem.InvalidTypeArgumentException e) {
                    throw new ExecutionError("type.argument", node);
                }
                catch (TypeSystem.UnmatchedLookupException e) {
                    if (e.matches() == 0) {
                        throw new ExecutionError("undefined.name.noinfo", node);
                    }
                    NodeProperties.setErrorStrings(node, nextId);
                    throw new ExecutionError("ambiguous.name", node);
                }
            }
            if (t == null) {
                NodeProperties.setErrorStrings(node, node.getRepresentation());
                throw new ExecutionError("undefined.class", node);
            }
            return NodeProperties.setType(node, t);
        }

        @Override
        public Type visit(HookTypeName node) {
            Type upper = TypeSystem.OBJECT;
            if (node.getUpperBound().isSome()) {
                upper = TypeNameChecker.this.checkStructure(node.getUpperBound().unwrap());
                if (!TypeNameChecker.this.ts.isReference(upper)) {
                    NodeProperties.setErrorStrings(node, TypeNameChecker.this.ts.typePrinter().print(upper));
                    throw new ExecutionError("wildcard.bound", node);
                }
            }
            Type lower = TypeSystem.NULL;
            if (node.getLowerBound().isSome()) {
                lower = TypeNameChecker.this.checkStructure(node.getLowerBound().unwrap());
                if (!TypeNameChecker.this.ts.isReference(lower)) {
                    NodeProperties.setErrorStrings(node, TypeNameChecker.this.ts.typePrinter().print(lower));
                    throw new ExecutionError("wildcard.bound", node);
                }
            }
            return NodeProperties.setType(node, new Wildcard(new BoundedSymbol(node, upper, lower)));
        }

        @Override
        public Type visit(ArrayTypeName node) {
            Type elementType = TypeNameChecker.this.checkStructure(node.getElementType());
            ArrayType arrayT = node.isVararg() ? new VarargArrayType(elementType) : new SimpleArrayType(elementType);
            return NodeProperties.setType(node, arrayT);
        }
    }
}

