/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.dynamicjava.interpreter;

import edu.rice.cs.dynamicjava.interpreter.AmbiguousNameException;
import edu.rice.cs.dynamicjava.interpreter.DelegatingContext;
import edu.rice.cs.dynamicjava.interpreter.TypeContext;
import edu.rice.cs.dynamicjava.symbol.DJClass;
import edu.rice.cs.dynamicjava.symbol.DJConstructor;
import edu.rice.cs.dynamicjava.symbol.DJMethod;
import edu.rice.cs.dynamicjava.symbol.Function;
import edu.rice.cs.dynamicjava.symbol.LocalFunction;
import edu.rice.cs.dynamicjava.symbol.LocalVariable;
import edu.rice.cs.dynamicjava.symbol.TypeSystem;
import edu.rice.cs.dynamicjava.symbol.type.ClassType;
import edu.rice.cs.dynamicjava.symbol.type.Type;
import edu.rice.cs.plt.iter.IterUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionContext
extends DelegatingContext {
    private final Function _f;

    public FunctionContext(TypeContext next, Function f) {
        super(next);
        this._f = f;
    }

    @Override
    protected FunctionContext duplicate(TypeContext next) {
        return new FunctionContext(next, this._f);
    }

    @Override
    public boolean variableExists(String name, TypeSystem ts) {
        return this.getParameter(name) != null || super.variableExists(name, ts);
    }

    @Override
    public boolean localVariableExists(String name, TypeSystem ts) {
        return this.getParameter(name) != null || super.localVariableExists(name, ts);
    }

    @Override
    public LocalVariable getLocalVariable(String name, TypeSystem ts) {
        LocalVariable result = this.getParameter(name);
        return result == null ? super.getLocalVariable(name, ts) : result;
    }

    @Override
    public boolean fieldExists(String name, TypeSystem ts) {
        return this.getParameter(name) == null ? super.fieldExists(name, ts) : false;
    }

    @Override
    public ClassType typeContainingField(String name, TypeSystem ts) throws AmbiguousNameException {
        return this.getParameter(name) == null ? super.typeContainingField(name, ts) : null;
    }

    private LocalVariable getParameter(String name) {
        for (LocalVariable v : this._f.parameters()) {
            if (!v.declaredName().equals(name)) continue;
            return v;
        }
        return null;
    }

    @Override
    public boolean functionExists(String name, TypeSystem ts) {
        return this.isLocalFunction(name) || super.functionExists(name, ts);
    }

    @Override
    public boolean localFunctionExists(String name, TypeSystem ts) {
        return this.isLocalFunction(name) || super.localFunctionExists(name, ts);
    }

    @Override
    public Iterable<LocalFunction> getLocalFunctions(String name, TypeSystem ts, Iterable<LocalFunction> partial) {
        if (IterUtil.isEmpty(partial)) {
            if (this.isLocalFunction(name)) {
                partial = IterUtil.singleton((LocalFunction)this._f);
            }
            return super.getLocalFunctions(name, ts, partial);
        }
        return partial;
    }

    @Override
    public boolean methodExists(String name, TypeSystem ts) {
        return this.isLocalFunction(name) ? false : super.methodExists(name, ts);
    }

    @Override
    public Type typeContainingMethod(String name, TypeSystem ts) {
        return this.isLocalFunction(name) ? null : super.typeContainingMethod(name, ts);
    }

    private boolean isLocalFunction(String name) {
        return this._f instanceof LocalFunction && ((LocalFunction)this._f).declaredName().equals(name);
    }

    @Override
    public String makeClassName(String n) {
        return super.makeAnonymousClassName() + n;
    }

    @Override
    public DJClass getThis() {
        if (this.isStatic()) {
            return null;
        }
        return super.getThis();
    }

    @Override
    public DJClass getThis(String className) {
        if (this.isStatic()) {
            return null;
        }
        return super.getThis(className);
    }

    @Override
    public DJClass getThis(Type expected, TypeSystem ts) {
        if (this.isStatic()) {
            return null;
        }
        return super.getThis(expected, ts);
    }

    @Override
    public DJClass initializingClass() {
        return this._f instanceof DJConstructor ? ((DJConstructor)this._f).declaringClass() : null;
    }

    @Override
    public Type getReturnType() {
        if (this._f instanceof DJConstructor) {
            return TypeSystem.VOID;
        }
        return this._f.returnType();
    }

    @Override
    public Iterable<Type> getDeclaredThrownTypes() {
        return this._f.thrownTypes();
    }

    private boolean isStatic() {
        return this._f instanceof DJMethod && ((DJMethod)this._f).isStatic();
    }
}

