/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.dynamicjava.interpreter;

import edu.rice.cs.dynamicjava.interpreter.AmbiguousNameException;
import edu.rice.cs.dynamicjava.interpreter.DelegatingContext;
import edu.rice.cs.dynamicjava.interpreter.TypeContext;
import edu.rice.cs.dynamicjava.symbol.DJClass;
import edu.rice.cs.dynamicjava.symbol.LocalFunction;
import edu.rice.cs.dynamicjava.symbol.LocalVariable;
import edu.rice.cs.dynamicjava.symbol.SymbolUtil;
import edu.rice.cs.dynamicjava.symbol.TypeSystem;
import edu.rice.cs.dynamicjava.symbol.type.ClassType;
import edu.rice.cs.dynamicjava.symbol.type.Type;
import edu.rice.cs.dynamicjava.symbol.type.VariableType;
import edu.rice.cs.plt.debug.DebugUtil;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.iter.SequenceIterator;
import edu.rice.cs.plt.lambda.LambdaUtil;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassContext
extends DelegatingContext {
    private final DJClass _c;
    private final ClassType _thisType;
    private final Iterator<Integer> _anonymousCounter;

    public ClassContext(TypeContext next, DJClass c) {
        super(next);
        this._c = c;
        this._thisType = SymbolUtil.thisType(c);
        this._anonymousCounter = new SequenceIterator<Integer>(1, LambdaUtil.INCREMENT_INT);
    }

    private ClassContext(TypeContext next, DJClass c, Iterator<Integer> anonymousCounter) {
        super(next);
        this._c = c;
        this._thisType = SymbolUtil.thisType(c);
        this._anonymousCounter = anonymousCounter;
    }

    @Override
    protected ClassContext duplicate(TypeContext next) {
        return new ClassContext(next, this._c, this._anonymousCounter);
    }

    @Override
    public boolean typeExists(String name, TypeSystem ts) {
        return this.hasMemberClass(name, ts) || super.typeExists(name, ts);
    }

    @Override
    public boolean memberClassExists(String name, TypeSystem ts) {
        return this.hasMemberClass(name, ts) || super.memberClassExists(name, ts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClassType typeContainingMemberClass(String name, TypeSystem ts) throws AmbiguousNameException {
        DebugUtil.debug.logStart(new String[]{"class", "name"}, this._c, name);
        try {
            if (this.hasMemberClass(name, ts)) {
                ClassType classType = this._thisType;
                return classType;
            }
            ClassType classType = super.typeContainingMemberClass(name, ts);
            return classType;
        }
        finally {
            DebugUtil.debug.logEnd();
        }
    }

    @Override
    public boolean topLevelClassExists(String name, TypeSystem ts) {
        return this.hasMemberClass(name, ts) ? false : super.topLevelClassExists(name, ts);
    }

    @Override
    public DJClass getTopLevelClass(String name, TypeSystem ts) throws AmbiguousNameException {
        return this.hasMemberClass(name, ts) ? null : super.getTopLevelClass(name, ts);
    }

    @Override
    public boolean typeVariableExists(String name, TypeSystem ts) {
        return this.hasMemberClass(name, ts) ? false : super.typeVariableExists(name, ts);
    }

    @Override
    public VariableType getTypeVariable(String name, TypeSystem ts) {
        return this.hasMemberClass(name, ts) ? null : super.getTypeVariable(name, ts);
    }

    private boolean hasMemberClass(String name, TypeSystem ts) {
        return ts.containsClass(this._thisType, name, this.accessModule());
    }

    @Override
    public boolean variableExists(String name, TypeSystem ts) {
        return this.hasField(name, ts) || super.variableExists(name, ts);
    }

    @Override
    public boolean fieldExists(String name, TypeSystem ts) {
        return this.hasField(name, ts) || super.fieldExists(name, ts);
    }

    @Override
    public ClassType typeContainingField(String name, TypeSystem ts) throws AmbiguousNameException {
        if (this.hasField(name, ts)) {
            return this._thisType;
        }
        return super.typeContainingField(name, ts);
    }

    @Override
    public boolean localVariableExists(String name, TypeSystem ts) {
        return this.hasField(name, ts) ? false : super.localVariableExists(name, ts);
    }

    @Override
    public LocalVariable getLocalVariable(String name, TypeSystem ts) {
        return this.hasField(name, ts) ? null : super.getLocalVariable(name, ts);
    }

    private boolean hasField(String name, TypeSystem ts) {
        return ts.containsField(this._thisType, name, this.accessModule());
    }

    @Override
    public boolean functionExists(String name, TypeSystem ts) {
        return this.hasMethod(name, ts) || super.functionExists(name, ts);
    }

    @Override
    public boolean methodExists(String name, TypeSystem ts) {
        return this.hasMethod(name, ts) || super.methodExists(name, ts);
    }

    @Override
    public Type typeContainingMethod(String name, TypeSystem ts) {
        return this.hasMethod(name, ts) ? this._thisType : super.typeContainingMethod(name, ts);
    }

    @Override
    public boolean localFunctionExists(String name, TypeSystem ts) {
        return this.hasMethod(name, ts) ? false : super.localFunctionExists(name, ts);
    }

    @Override
    public Iterable<LocalFunction> getLocalFunctions(String name, TypeSystem ts, Iterable<LocalFunction> partial) {
        return !IterUtil.isEmpty(partial) || this.hasMethod(name, ts) ? partial : super.getLocalFunctions(name, ts, partial);
    }

    private boolean hasMethod(String name, TypeSystem ts) {
        return ts.containsMethod(this._thisType, name, this.accessModule());
    }

    @Override
    public String makeClassName(String n) {
        return this._c.fullName() + "$" + n;
    }

    @Override
    public String makeAnonymousClassName() {
        return this.makeClassName(this._anonymousCounter.next().toString());
    }

    @Override
    public DJClass getThis() {
        return this._c;
    }

    @Override
    public DJClass getThis(String className) {
        if (!this._c.isAnonymous() && className.equals(this._c.declaredName())) {
            return this._c;
        }
        return super.getThis(className);
    }

    @Override
    public DJClass getThis(Type expected, TypeSystem ts) {
        if (ts.isSubtype(this._thisType, expected)) {
            return this._c;
        }
        return super.getThis(expected, ts);
    }

    @Override
    public DJClass initializingClass() {
        return null;
    }

    @Override
    public Type getReturnType() {
        return null;
    }

    @Override
    public Iterable<Type> getDeclaredThrownTypes() {
        return IterUtil.empty();
    }
}

